/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro.filters;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCheckFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(ResourceCheckFilter.class);
    private String errorUrl;

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    protected boolean isAccessAllowed(ServletRequest servletRequest, ServletResponse servletResponse, Object o) throws Exception {
        Subject subject = this.getSubject(servletRequest, servletResponse);
        String url = this.getPathWithinApplication(servletRequest);
        log.info("\u5f53\u524d\u7528\u6237\u6b63\u5728\u8bbf\u95ee\u7684 url => " + url);
        return subject.isPermitted(url);
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        log.info("\u5f53 isAccessAllowed \u8fd4\u56de false \u7684\u65f6\u5019\uff0c\u624d\u4f1a\u6267\u884c method onAccessDenied ");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.sendRedirect(request.getContextPath() + this.errorUrl);
        return false;
    }
}

