/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.geoAnalysis.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jeecg.modules.commonQueryConfig.entity.CommonQueryConfig;
import org.jeecg.modules.geoAnalysis.entity.GeoAnalysis;
import org.jeecg.modules.geoAnalysis.entity.Result;
import org.jeecg.modules.geoAnalysis.entity.ZYFXPZB;
import org.jeecg.modules.geoAnalysis.mapper.GeoAnalysisMapper;
import org.jeecg.modules.geoAnalysis.service.IGeoAnlysisService;
import org.jeecg.modules.util.ZipUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeoAnalysisServiceImpl
extends ServiceImpl<GeoAnalysisMapper, GeoAnalysis>
implements IGeoAnlysisService {
    private static final Logger log = LoggerFactory.getLogger(GeoAnalysisServiceImpl.class);
    @Autowired
    GeoAnalysisMapper geoAnalysisMapper;

    @Override
    public ArrayList<GeoAnalysis> DrawMap(List<ZYFXPZB> zyfxpzb, String[] shape) {
        ArrayList<GeoAnalysis> list = new ArrayList<GeoAnalysis>();
        DecimalFormat format = new DecimalFormat("0.0000");
        for (ZYFXPZB zyfxpzb1 : zyfxpzb) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String atableenam = zyfxpzb1.getATABLEENAME();
            String afieldename = zyfxpzb1.getAFIELDENAME();
            String atablecname = zyfxpzb1.getATABLECNAME();
            String afieldcname = zyfxpzb1.getAFIELDCNAME();
            hashMap.put("shape", shape);
            hashMap.put("table", atableenam);
            hashMap.put("DLMC", afieldename);
            List<HashMap<String, Object>> hashMaps = this.geoAnalysisMapper.DrawMap(hashMap);
            for (HashMap<String, Object> map : hashMaps) {
                GeoAnalysis analysis = new GeoAnalysis();
                Result result = new Result();
                analysis.setType(atablecname);
                result.setArea(format.format(new BigDecimal(map.get("AREA").toString())));
                result.setTypes(map.get(afieldename).toString());
                result.setObjectid(map.get("OBJECTID").toString());
                if (map.get("INFO") instanceof Clob) {
                    Clob clob = (Clob)map.get("INFO");
                    try {
                        result.setInfo(clob.getSubString(1L, (int)clob.length()));
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
                result.setAtableenam(atableenam);
                analysis.setResult(result);
                analysis.setAfieldcname(afieldcname);
                list.add(analysis);
            }
        }
        return list;
    }

    @Override
    public ZYFXPZB SelectByTbs(String MTABLENAME, String atableename) {
        return this.geoAnalysisMapper.SelectByTbs(MTABLENAME, atableename);
    }

    @Override
    public List<ZYFXPZB> SelectByTb(String MTABLENAME) {
        return this.geoAnalysisMapper.SelectByTb(MTABLENAME);
    }

    @Override
    public ArrayList<GeoAnalysis> DrawMapByShape(List<ZYFXPZB> zyfxpzb, String[] shape, String table) {
        ArrayList<GeoAnalysis> list = new ArrayList<GeoAnalysis>();
        DecimalFormat format = new DecimalFormat("0.0000");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (ZYFXPZB zyfxpzb1 : zyfxpzb) {
                map.put("DLMC", zyfxpzb1.getAFIELDENAME());
                map.put("table", zyfxpzb1.getATABLEENAME());
                map.put("tables", table);
                map.put("shape", shape);
                List<HashMap<String, Object>> hashMaps = this.geoAnalysisMapper.DrawMapByShape(map);
                for (HashMap<String, Object> hashMap : hashMaps) {
                    if (hashMap.get(zyfxpzb1.getAFIELDENAME()) == null || hashMap.get("AREA") == null) continue;
                    GeoAnalysis analysis = new GeoAnalysis();
                    Result result = new Result();
                    analysis.setType(zyfxpzb1.getATABLECNAME());
                    analysis.setAfieldcname(zyfxpzb1.getAFIELDCNAME());
                    result.setTypes(hashMap.get(zyfxpzb1.getAFIELDENAME()).toString());
                    result.setArea(format.format(new BigDecimal(hashMap.get("AREA").toString())));
                    result.setObjectid(hashMap.get("OBJECTID").toString());
                    if (hashMap.get("INFO") instanceof Clob) {
                        Clob clob = (Clob)hashMap.get("INFO");
                        try {
                            result.setInfo(clob.getSubString(1L, (int)clob.length()));
                        }
                        catch (SQLException throwables) {
                            throwables.printStackTrace();
                        }
                    }
                    result.setAtableenam(zyfxpzb1.getATABLEENAME());
                    analysis.setResult(result);
                    list.add(analysis);
                }
            }
            if (table.equals("GD_DKXX")) {
                HashMap<String, String[]> maps = new HashMap<String, String[]>();
                maps.put("shape", shape);
                HashMap<String, Object> gdxmjbxx = this.geoAnalysisMapper.SelectGdxmjbxx(maps);
                list.add((GeoAnalysis)((Object)gdxmjbxx));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(list);
        return list;
    }

    @Override
    public HashMap<String, Object> SelectDetails(HashMap map) {
        return this.geoAnalysisMapper.SelectDetails(map);
    }

    @Override
    public ArrayList<CommonQueryConfig> SelectByTable(String TABLEALIAS) {
        return this.geoAnalysisMapper.SelectByTable(TABLEALIAS);
    }

    @Override
    public Boolean exportShps(HttpServletResponse response, String id) {
        List<Map<String, Object>> list = this.geoAnalysisMapper.exportShp(id);
        boolean b = GeoAnalysisServiceImpl.exportShp(response, list);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportShp(HttpServletResponse response, List<Map<String, Object>> list) {
        boolean flag = false;
        FileOutputStream fileOutputStream = null;
        String id = UUID.randomUUID().toString();
        String tempPath = "D:/temp/" + id + "/";
        String shpFilePath = tempPath + id + ".shp";
        String zippath = "D:/temp/" + id + ".zip";
        File dir = new File(tempPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File zipfile = new File(zippath);
        File shpFile = new File(shpFilePath);
        try {
            int len;
            SimpleFeatureType TYPE = DataUtilities.createType((String)"Location", (String)"the_geom:MultiPolygon,DKMC:String");
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
            for (Map<String, Object> row : list) {
                if (row.get("GEOM") instanceof Clob) {
                    Clob clob = (Clob)row.get("GEOM");
                    try {
                        row.put("GEOM", clob.getSubString(1L, (int)clob.length()));
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                }
                String wkt = row.get("GEOM").toString();
                WKTReader wktReader = new WKTReader();
                Geometry geometry = null;
                try {
                    geometry = wktReader.read(wkt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                featureBuilder.add((Object)geometry);
                System.out.println("78888888888888888888888" + row.get("DKMC"));
                featureBuilder.add(row.get("DKMC"));
                SimpleFeature feature = featureBuilder.buildFeature(null);
                features.add(feature);
            }
            ListFeatureCollection collection = new ListFeatureCollection(TYPE, features);
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", shpFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(TYPE);
            newDataStore.setCharset(Charset.forName("GBK"));
            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures((FeatureCollection)collection);
                    transaction.commit();
                }
                catch (Exception problem) {
                    problem.printStackTrace();
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            }
            FileOutputStream fos1 = new FileOutputStream(zipfile);
            ZipUtils.toZip(tempPath, fos1, true);
            FileInputStream inStream = new FileInputStream(zippath);
            response.reset();
            response.setContentType("bin");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(zipfile.getName(), "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((len = ((InputStream)inStream).read(b)) > 0) {
                outputStream.write(b, 0, len);
            }
            ((InputStream)inStream).close();
            outputStream.flush();
            outputStream.close();
            flag = true;
        }
        catch (Exception e) {
            log.error("\u3010shp\u5bfc\u51fa\u5931\u8d25\u3011" + e.getMessage());
        }
        finally {
            File filedir;
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    log.error("\u3010shp\u5bfc\u51fa\u6d41\u5173\u95ed\u5931\u8d25\u3011" + e.getMessage());
                }
            }
            if ((filedir = new File(tempPath)).exists() && filedir.isDirectory()) {
                File[] files;
                for (File f : files = filedir.listFiles()) {
                    if (!f.exists()) continue;
                    f.delete();
                }
                filedir.delete();
            }
            if (zipfile.exists()) {
                zipfile.delete();
            }
        }
        return flag;
    }
}

