/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.resManager.catalog.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.SelectTreeModel;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.model.TreeModel;
import org.jeecg.modules.resManager.catalog.entity.Rescatalog;
import org.jeecg.modules.resManager.catalog.service.IRescatalogService;
import org.jeecg.modules.topicManage.entity.TopicsConfig;
import org.jeecg.modules.topicManage.service.ITopicsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"rescatalog"})
@RestController
@RequestMapping(value={"/resManager.catalog/rescatalog"})
public class RescatalogController
extends JeecgController<Rescatalog, IRescatalogService> {
    private static final Logger log = LoggerFactory.getLogger(RescatalogController.class);
    @Autowired
    private IRescatalogService rescatalogService;
    @Autowired
    private ITopicsConfigService topicsConfigService;

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u7528\u6237\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u7528\u6237\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2", notes="\u8d44\u6e90\u76ee\u5f55-\u7528\u6237\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @GetMapping(value={"/resListByUser"})
    public Result<?> getResListByUserName(@RequestParam(value="username") String username, @RequestParam(value="topicId") String topicId) {
        long start = System.currentTimeMillis();
        List<Object> resList = new ArrayList();
        resList = this.getResListByUser("0", username, topicId);
        log.info("======\u7528\u6237\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        return Result.OK(resList);
    }

    private List<JSONObject> getResListByUser(String pid, String username, String topicId) {
        ArrayList<JSONObject> resList = new ArrayList<JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Rescatalog::getPid, (Object)pid)).orderByAsc(Rescatalog::getDisplayorder);
        List resCatalogs = this.rescatalogService.list((Wrapper)queryWrapper);
        if (resCatalogs.size() > 0) {
            String displayers = "";
            String analysistypes = "";
            if (!"null".equals(topicId) && !topicId.isEmpty()) {
                LambdaQueryWrapper topicsConfigLambdaQueryWrapper = new LambdaQueryWrapper();
                topicsConfigLambdaQueryWrapper.eq(TopicsConfig::getTopicid, (Object)topicId);
                TopicsConfig topicsConfig = (TopicsConfig)this.topicsConfigService.getOne((Wrapper)topicsConfigLambdaQueryWrapper);
                displayers = topicsConfig.getDisplayers() == null ? "" : topicsConfig.getDisplayers();
                analysistypes = topicsConfig.getAnalysistypes() == null ? "" : topicsConfig.getAnalysistypes();
            }
            for (int i = 0; i < resCatalogs.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                Rescatalog rescatalog = (Rescatalog)resCatalogs.get(i);
                String res_id = rescatalog.getId();
                int resCount = this.rescatalogService.queryCountByUsername(username, res_id);
                if (resCount == 0) continue;
                String has_child = rescatalog.getHasChild();
                if ("1".equals(has_child)) {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getAlias());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                    jsonObject.put("layers", this.getResListByUser(rescatalog.getId(), username, topicId));
                } else {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getName());
                    jsonObject.put("alias", (Object)rescatalog.getAlias());
                    jsonObject.put("url", (Object)rescatalog.getUrl());
                    jsonObject.put("sublayerid", (Object)rescatalog.getSublayerid());
                    jsonObject.put("dataport", (Object)rescatalog.getDataport());
                    jsonObject.put("relfield", (Object)rescatalog.getRelfield());
                    jsonObject.put("legend", (Object)rescatalog.getLegend());
                    if (!displayers.isEmpty() && displayers.indexOf(rescatalog.getId()) != -1) {
                        jsonObject.put("visible", (Object)true);
                    } else {
                        jsonObject.put("visible", (Object)Boolean.parseBoolean(rescatalog.getVisible()));
                    }
                    jsonObject.put("labelsvisible", (Object)Boolean.parseBoolean(rescatalog.getLabelsvisible()));
                    if (analysistypes.isEmpty()) {
                        jsonObject.put("analyzable", (Object)Boolean.parseBoolean(rescatalog.getAnalyzable()));
                    } else if (analysistypes.indexOf(rescatalog.getId()) != -1) {
                        jsonObject.put("analyzable", (Object)true);
                    } else {
                        jsonObject.put("analyzable", (Object)false);
                    }
                    jsonObject.put("sourceName", (Object)rescatalog.getSourcename());
                    jsonObject.put("queryable", (Object)Boolean.parseBoolean(rescatalog.getQueryable()));
                    jsonObject.put("tablename", (Object)rescatalog.getTablename());
                    jsonObject.put("servicetype", (Object)rescatalog.getServicetype());
                    jsonObject.put("zIndex", (Object)rescatalog.getZindex());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                }
                resList.add(jsonObject);
            }
        }
        return resList;
    }

    @AutoLog(value="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @ApiOperation(value="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2", notes="\u8d44\u6e90\u76ee\u5f55-\u8d44\u6e90\u76ee\u5f55\u67e5\u8be2")
    @GetMapping(value={"/resList"})
    public Result<?> getResList() {
        List<Object> resList = new ArrayList();
        resList = this.getResListByPid("0");
        return Result.OK(resList);
    }

    private List<JSONObject> getResListByPid(String pid) {
        ArrayList<JSONObject> resList = new ArrayList<JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Rescatalog::getPid, (Object)pid)).orderByAsc(Rescatalog::getDisplayorder);
        List resCatalogs = this.rescatalogService.list((Wrapper)queryWrapper);
        if (resCatalogs.size() > 0) {
            for (int i = 0; i < resCatalogs.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                Rescatalog rescatalog = (Rescatalog)resCatalogs.get(i);
                String has_child = rescatalog.getHasChild();
                if ("1".equals(has_child)) {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getAlias());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                    jsonObject.put("layers", this.getResListByPid(rescatalog.getId()));
                } else {
                    jsonObject.put("id", (Object)rescatalog.getId());
                    jsonObject.put("name", (Object)rescatalog.getName());
                    jsonObject.put("alias", (Object)rescatalog.getAlias());
                    jsonObject.put("url", (Object)rescatalog.getUrl());
                    jsonObject.put("sublayerid", (Object)rescatalog.getSublayerid());
                    jsonObject.put("dataport", (Object)rescatalog.getDataport());
                    jsonObject.put("relfield", (Object)rescatalog.getRelfield());
                    jsonObject.put("legend", (Object)rescatalog.getLegend());
                    jsonObject.put("visible", (Object)Boolean.parseBoolean(rescatalog.getVisible()));
                    jsonObject.put("labelsvisible", (Object)Boolean.parseBoolean(rescatalog.getLabelsvisible()));
                    jsonObject.put("analyzable", (Object)Boolean.parseBoolean(rescatalog.getAnalyzable()));
                    jsonObject.put("sourceName", (Object)rescatalog.getSourcename());
                    jsonObject.put("queryable", (Object)Boolean.parseBoolean(rescatalog.getQueryable()));
                    jsonObject.put("tablename", (Object)rescatalog.getTablename());
                    jsonObject.put("servicetype", (Object)rescatalog.getServicetype());
                    jsonObject.put("zIndex", (Object)rescatalog.getZindex());
                    jsonObject.put("displayorder", (Object)rescatalog.getDisplayorder());
                }
                resList.add(jsonObject);
            }
        }
        return resList;
    }

    @AutoLog(value="rescatalog-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="rescatalog-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="rescatalog-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/rootList"})
    public Result<IPage<Rescatalog>> queryPageList(Rescatalog rescatalog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String hasQuery = req.getParameter("hasQuery");
        if (hasQuery != null && "true".equals(hasQuery)) {
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
            List<Rescatalog> list = this.rescatalogService.queryTreeListNoPage((QueryWrapper<Rescatalog>)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        String parentId = rescatalog.getPid();
        if (oConvertUtils.isEmpty((Object)parentId)) {
            parentId = "0";
        }
        rescatalog.setPid(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"pid", (Object)parentId);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.rescatalogService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @RequestMapping(value={"/loadTreeChildren"}, method={RequestMethod.GET})
    public Result<List<SelectTreeModel>> loadTreeChildren(@RequestParam(name="pid") String pid) {
        Result result = new Result();
        try {
            List<SelectTreeModel> ls = this.rescatalogService.queryListByPid(pid);
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeRoot"}, method={RequestMethod.GET})
    public Result<List<SelectTreeModel>> loadTreeRoot(@RequestParam(name="async") Boolean async, @RequestParam(name="pcode") String pcode) {
        Result result = new Result();
        try {
            List<SelectTreeModel> ls = this.rescatalogService.queryListByCode(pcode);
            if (!async.booleanValue()) {
                this.loadAllChildren(ls);
            }
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void loadAllChildren(List<SelectTreeModel> ls) {
        for (SelectTreeModel tsm : ls) {
            List<SelectTreeModel> temp = this.rescatalogService.queryListByPid(tsm.getKey());
            if (temp == null || temp.size() <= 0) continue;
            tsm.setChildren(temp);
            this.loadAllChildren(temp);
        }
    }

    @ApiOperation(value="rescatalog-\u83b7\u53d6\u5b50\u6570\u636e", notes="rescatalog-\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/childList"})
    public Result<IPage<Rescatalog>> queryPageList(Rescatalog rescatalog, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)rescatalog, (Map)req.getParameterMap());
        List list = this.rescatalogService.list((Wrapper)queryWrapper);
        Page pageList = new Page(1L, 10L, (long)list.size());
        pageList.setRecords(list);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="rescatalog-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e", notes="rescatalog-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/getChildListBatch"})
    public Result getChildListBatch(@RequestParam(value="parentIds") String parentIds) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> parentIdList = Arrays.asList(parentIds.split(","));
            queryWrapper.in((Object)"pid", parentIdList);
            List list = this.rescatalogService.list((Wrapper)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6279\u91cf\u67e5\u8be2\u5b50\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @AutoLog(value="rescatalog-\u6dfb\u52a0")
    @ApiOperation(value="rescatalog-\u6dfb\u52a0", notes="rescatalog-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody Rescatalog rescatalog) {
        int subLayerId;
        if (rescatalog.getSublayerid() != null && (subLayerId = rescatalog.getSublayerid().intValue()) > -1) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(Rescatalog::getSublayerid, (Object)subLayerId);
            List resCatalogList = this.rescatalogService.list((Wrapper)queryWrapper);
            if (resCatalogList.size() > 0) {
                this.rescatalogService.subLayerIdAdditive(subLayerId);
            }
        }
        this.rescatalogService.addRescatalog(rescatalog);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="rescatalog-\u7f16\u8f91")
    @ApiOperation(value="rescatalog-\u7f16\u8f91", notes="rescatalog-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody Rescatalog rescatalog) {
        this.rescatalogService.updateRescatalog(rescatalog);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="rescatalog-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="rescatalog-\u901a\u8fc7id\u5220\u9664", notes="rescatalog-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        int subLayerId;
        Rescatalog rescatalog = (Rescatalog)this.rescatalogService.getById((Serializable)((Object)id));
        if (rescatalog.getSublayerid() != null && (subLayerId = rescatalog.getSublayerid().intValue()) > -1) {
            this.rescatalogService.subLayerIdDecrement(subLayerId);
        }
        this.rescatalogService.deleteRescatalog(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="rescatalog-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="rescatalog-\u6279\u91cf\u5220\u9664", notes="rescatalog-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.rescatalogService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="rescatalog-\u901a\u8fc7id\u67e5\u8be2", notes="rescatalog-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<Rescatalog> queryById(@RequestParam(name="id", required=true) String id) {
        Rescatalog rescatalog = (Rescatalog)this.rescatalogService.getById((Serializable)((Object)id));
        if (rescatalog == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)rescatalog);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, Rescatalog rescatalog) {
        return super.exportXls(request, (Object)rescatalog, Rescatalog.class, "rescatalog");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Rescatalog.class);
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList(HttpServletRequest request) {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.orderByAsc(Rescatalog::getDisplayorder);
            List list = this.rescatalogService.list((Wrapper)query);
            for (Rescatalog rescatalog : list) {
                ids.add(rescatalog.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Rescatalog> rescatalogList, TreeModel temp) {
        for (Rescatalog rescatalog : rescatalogList) {
            String tempPid = rescatalog.getPid();
            Integer ruleFlag = 0;
            Boolean isLeaf = rescatalog.getHasChild().equals("0");
            TreeModel tree = new TreeModel(rescatalog.getId(), tempPid, rescatalog.getAlias(), ruleFlag, isLeaf);
            if (temp == null && "0".equals(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, rescatalogList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, rescatalogList, tree);
        }
    }
}

