/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.common.util;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jeewx.api.core.common.util.StringTemplateLoader;

public class FreemarkerUtil {
    private static Configuration _tplConfig = new Configuration();

    public FreemarkerUtil() {
    }

    public FreemarkerUtil(String dir) {
        try {
            _tplConfig.setDirectoryForTemplateLoading(new File(dir));
            _tplConfig.setClassicCompatible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String parseTemplate(String tplName, String encoding, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = null;
            mytpl = _tplConfig.getTemplate(tplName, encoding);
            mytpl.process(paras, (Writer)swriter);
            return swriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genStaticPage(String tplPath, String tplName, Map<String, Object> paras) {
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(tplName), "UTF-8");
            Template mytpl = null;
            mytpl = _tplConfig.getTemplate(tplPath, "UTF-8");
            mytpl.process(paras, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String parseTemplate(String tplName, Map<String, Object> paras) {
        return this.parseTemplate(tplName, "utf-8", paras);
    }

    public String parseTemplateContent(String tplContent, Map<String, Object> paras, String encoding) {
        Configuration cfg = new Configuration();
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        encoding = encoding == null ? "UTF-8" : encoding;
        cfg.setDefaultEncoding(encoding);
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        Configuration cfg = new Configuration();
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        cfg.setDefaultEncoding("UTF-8");
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

