/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.affine.AffineOpImage;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class AffineBicubicOpImage
extends AffineOpImage {
    private static final int KERNEL_LINE_DIM = 4;
    private static final float OVERFLOW = 1.0f;
    private static final float AVOID_OVERFLOW = 0.999999f;
    protected InterpolationBicubic interpBN = null;
    protected byte[][] byteLookupTable;
    static final BorderExtender roiExtender = BorderExtender.createInstance((int)0);
    private boolean setDestinationNoData;
    private int[] dataHi;
    private int[] dataVi;
    private float[] dataHf;
    private float[] dataVf;
    private double[] dataHd;
    private double[] dataVd;
    protected int subsampleBits;
    private int shift;
    private int round;
    private int precisionBits;

    public AffineBicubicOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, AffineTransform transform, Interpolation interp, double[] backgroundValues, boolean setDestinationNoData, boolean useROIAccessor, Range nodata) {
        super(source, extender, config, layout, transform, interp, backgroundValues);
        this.affineOpInitialization(source, interp, layout, backgroundValues, useROIAccessor, setDestinationNoData, nodata);
    }

    private void affineOpInitialization(RenderedImage source, Interpolation interp, ImageLayout layout, double[] backgroundValues, boolean useROIAccessor, boolean setDestinationNoData, Range nodata) {
        int i;
        SampleModel sm = source.getSampleModel();
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel && ImageUtil.isBinary((SampleModel)sm)) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        int numBands = this.getSampleModel().getNumBands();
        int srcDataType = sm.getDataType();
        Range nod = nodata;
        double[] destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues;
        }
        if (interp instanceof InterpolationBicubic) {
            this.interpBN = (InterpolationBicubic)interp;
            this.interp = this.interpBN;
            this.interpBN.setROIBounds(this.roiBounds);
            this.noData = this.interpBN.getNoDataRange();
            switch (srcDataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.dataHi = this.interpBN.getHorizontalTableData();
                    this.dataVi = this.interpBN.getVerticalTableData();
                    break;
                }
                case 4: {
                    this.dataHf = this.interpBN.getHorizontalTableDataFloat();
                    this.dataVf = this.interpBN.getVerticalTableDataFloat();
                    break;
                }
                case 5: {
                    this.dataHd = this.interpBN.getHorizontalTableDataDouble();
                    this.dataVd = this.interpBN.getVerticalTableDataDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data Type");
                }
            }
            this.subsampleBits = this.interpBN.getSubsampleBitsH();
            this.shift = 1 << this.subsampleBits;
            this.precisionBits = this.interpBN.getPrecisionBits();
            if (this.precisionBits > 0) {
                this.round = 1 << this.precisionBits - 1;
            }
            if (nod == null) {
                nod = this.interpBN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpBN.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useROIAccessor = useROIAccessor;
        }
        this.setDestinationNoData = setDestinationNoData;
        this.setBackground = setDestinationNoData;
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (srcDataType == 0 && this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                byte value = (byte)i;
                for (int b = 0; b < numBands; ++b) {
                    if (this.noData.contains(value)) {
                        if (setDestinationNoData) {
                            this.byteLookupTable[b][i] = this.destinationNoDataByte[b];
                            continue;
                        }
                        this.byteLookupTable[b][i] = 0;
                        if (i == 0) continue;
                        this.byteLookupTable[b][0] = 1;
                        continue;
                    }
                    this.byteLookupTable[b][i] = value;
                }
            }
        }
        if (this.destinationNoDataDouble != null) {
            this.setProperty("GC_NODATA", new NoDataContainer(this.destinationNoDataDouble));
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        int srcRectX = srcRect.x;
        int srcRectY = srcRect.y;
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useROIAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            } else {
                roiIter = RandomIterFactory.create((RenderedImage)this.srcROIImgExt, (Rectangle)this.roiRect, (boolean)true, (boolean)true);
            }
        }
        int dataType = dest.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 3: {
                this.intLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            long sum = 0L;
                            int result = 0;
                            for (int h = 0; h < 4; ++h) {
                                long temp = 0L;
                                for (int z = 0; z < 4; ++z) {
                                    int pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]] & 0xFF;
                                    temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                                }
                                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 255) {
                                result = 255;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (byte)(result & 0xFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataByte[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]] & 0xFF;
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataByte[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > 255) {
                                    result = 255;
                                } else if (result < 0) {
                                    result = 0;
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (byte)(result & 0xFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataByte[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k23]] & 0xFF;
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataByte[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > 255) {
                                    result = 255;
                                } else if (result < 0) {
                                    result = 0;
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (byte)(result & 0xFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                double s_x = ((Point2D)src_pt).getX();
                double s_y = ((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x -= 0.5);
                int s_iy = (int)Math.floor(s_y -= 0.5);
                fracx = s_x - (double)s_ix * 1.0;
                fracy = s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            long[] tempData;
                            byte[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    int sample = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]] & 0xFF;
                                    pixelKernel[h][z] = sample;
                                    weight = this.byteLookupTable[k2][sample] != this.destinationNoDataByte[k2] ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                                continue;
                            }
                            tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = sum + (long)this.round >> this.precisionBits;
                            weight = 0;
                            weightVert = 0;
                            sum = 0L;
                            result = InterpolationBicubic.clampAndFixOvershootingByte((int)((int)result), (byte)this.destinationNoDataByte[k2]);
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (byte)(result & 0xFFL);
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataByte[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k24]] & 0xFF;
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = this.byteLookupTable[k24][(int)pixelKernel[h][z]] != this.destinationNoDataByte[k24] ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataByte[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * (long)this.dataVi[offsetY + h2];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 255) {
                                result = 255;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = (byte)(result & 0xFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataByte[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k25]] & 0xFF;
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = this.byteLookupTable[k25][(int)pixelKernel[h][z]] != this.destinationNoDataByte[k25] ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataByte[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * (long)this.dataVi[offsetY + h3];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 255) {
                                result = 255;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (byte)(result & 0xFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void ushortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            long sum = 0L;
                            int result = 0;
                            for (int h = 0; h < 4; ++h) {
                                long temp = 0L;
                                for (int z = 0; z < 4; ++z) {
                                    int pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]] & 0xFFFF;
                                    temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                                }
                                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 65535) {
                                result = 65535;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)(result & 0xFFFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataUShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]] & 0xFFFF;
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataUShort[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > 65535) {
                                    result = 65535;
                                } else if (result < 0) {
                                    result = 0;
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (short)(result & 0xFFFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataUShort[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k23]] & 0xFFFF;
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataUShort[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > 65535) {
                                    result = 65535;
                                } else if (result < 0) {
                                    result = 0;
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (short)(result & 0xFFFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            short[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]] & 0xFFFF;
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                                continue;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            result = InterpolationBicubic.clampAndFixOvershootingUShort((int)((int)result), (short)this.destinationNoDataUShort[k2]);
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)(result & 0xFFFFL);
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataUShort[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k24]] & 0xFFFF;
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataUShort[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * (long)this.dataVi[offsetY + h2];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 65535) {
                                result = 65535;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = (short)(result & 0xFFFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k25]] & 0xFFFF;
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * (long)this.dataVi[offsetY + h3];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > 65535) {
                                result = 65535;
                            } else if (result < 0) {
                                result = 0;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (short)(result & 0xFFFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void shortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            long sum = 0L;
                            int result = 0;
                            for (int h = 0; h < 4; ++h) {
                                long temp = 0L;
                                for (int z = 0; z < 4; ++z) {
                                    short pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]];
                                    temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                                }
                                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > Short.MAX_VALUE) {
                                result = Short.MAX_VALUE;
                            } else if (result < Short.MIN_VALUE) {
                                result = Short.MIN_VALUE;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)result;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataShort[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > Short.MAX_VALUE) {
                                    result = Short.MAX_VALUE;
                                } else if (result < Short.MIN_VALUE) {
                                    result = Short.MIN_VALUE;
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (short)result;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataShort[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataShort[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                result = (int)(sum + (long)this.round >> this.precisionBits);
                                if (result > Short.MAX_VALUE) {
                                    result = Short.MAX_VALUE;
                                } else if (result < Short.MIN_VALUE) {
                                    result = Short.MIN_VALUE;
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (short)result;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            long result = 0L;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            short[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                                continue;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            if (result > 32767L) {
                                result = 32767L;
                            } else if (result < -32768L) {
                                result = -32768L;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)result;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataShort[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataShort[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * (long)this.dataVi[offsetY + h2];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > Short.MAX_VALUE) {
                                result = Short.MAX_VALUE;
                            } else if (result < Short.MIN_VALUE) {
                                result = Short.MIN_VALUE;
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = (short)result;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * (long)this.dataVi[offsetY + h3];
                            }
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            if (result > Short.MAX_VALUE) {
                                result = Short.MAX_VALUE;
                            } else if (result < Short.MIN_VALUE) {
                                result = Short.MIN_VALUE;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (short)result;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void intLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            long sum = 0L;
                            int result = 0;
                            for (int h = 0; h < 4; ++h) {
                                long temp = 0L;
                                for (int z = 0; z < 4; ++z) {
                                    int pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]];
                                    temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                                }
                                sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result = (int)(sum + (long)this.round >> this.precisionBits);
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataInt[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataInt[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = result = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataInt[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                long sum = 0L;
                                int[][] pixelKernel = new int[4][4];
                                int result = 0;
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataInt[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                    }
                                    sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = result = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int result = 0;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            int[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                                continue;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            result = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataInt[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataInt[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * (long)this.dataVi[offsetY + h2];
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = result = (int)(sum + (long)this.round >> this.precisionBits);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            long sum = 0L;
                            int result = 0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                long tempSum = 0L;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                            }
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * (long)this.dataVi[offsetY + h3];
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = result = (int)(sum + (long)this.round >> this.precisionBits);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void floatLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            float sum = 0.0f;
                            for (int h = 0; h < 4; ++h) {
                                float temp = 0.0f;
                                for (int z = 0; z < 4; ++z) {
                                    float pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]];
                                    temp += pixelValue * this.dataHf[offsetX + z];
                                }
                                sum += temp * this.dataVf[offsetY + h];
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = sum;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataFloat[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                float sum = 0.0f;
                                float[][] pixelKernel = new float[4][4];
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataFloat[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    float tempSum = 0.0f;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += pixelKernel[h][z] * this.dataHf[offsetX + z];
                                    }
                                    sum += tempSum * this.dataVf[offsetY + h];
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = sum;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataFloat[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                float sum = 0.0f;
                                float[][] pixelKernel = new float[4][4];
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataFloat[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    float tempSum = 0.0f;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += pixelKernel[h][z] * this.dataHf[offsetX + z];
                                    }
                                    sum += tempSum * this.dataVf[offsetY + h];
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = sum;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            float[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    float value = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    pixelKernel[h][z] = value;
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * (double)this.dataHf[offsetX] + tempData[1] * (double)this.dataHf[offsetX + 1] + tempData[2] * (double)this.dataHf[offsetX + 2] + tempData[3] * (double)this.dataHf[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                                continue;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (double)this.dataVf[offsetY] + tempData[1] * (double)this.dataVf[offsetY + 1] + tempData[2] * (double)this.dataVf[offsetY + 2] + tempData[3] * (double)this.dataVf[offsetY + 3];
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (float)sum;
                            sum = 0.0;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataFloat[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            double sum = 0.0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    float value = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    pixelKernel[h][z] = value;
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataFloat[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * (double)this.dataVf[offsetY + h2];
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = (float)sum;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            double sum = 0.0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    float value = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    pixelKernel[h][z] = value;
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * (double)this.dataVf[offsetY + h3];
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (float)sum;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void doubleLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        float src_rect_x11 = src_rect_x1 + 1.0f;
        float src_rect_y11 = src_rect_y1 + 1.0f;
        float src_rect_x22 = src_rect_x2 - 2.0f;
        float src_rect_y22 = src_rect_y2 - 2.0f;
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                double s_x = ((Point2D)src_pt).getX();
                double s_y = ((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x -= 0.5);
                int s_iy = (int)Math.floor(s_y -= 0.5);
                fracx = s_x - (double)s_ix * 1.0;
                fracy = s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            double sum = 0.0;
                            for (int h = 0; h < 4; ++h) {
                                double temp = 0.0;
                                for (int z = 0; z < 4; ++z) {
                                    double pixelValue = srcDataArrays[k2][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k2]];
                                    temp += pixelValue * this.dataHd[offsetX + z];
                                }
                                sum += temp * this.dataVd[offsetY + h];
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = sum;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    double s_x = ((Point2D)src_pt).getX();
                    double s_y = ((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x -= 0.5);
                    int s_iy = (int)Math.floor(s_y -= 0.5);
                    fracx = s_x - (double)s_ix * 1.0;
                    fracy = s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int baseIndex = posx / dst_num_bands + posyROI;
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataDouble[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int h;
                                double sum = 0.0;
                                double[][] pixelKernel = new double[4][4];
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k22][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride + bandOffsets[k22]];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataDouble[k22];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += pixelKernel[h][z] * this.dataHd[offsetX + z];
                                    }
                                    sum += tempSum * this.dataVd[offsetY + h];
                                }
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = sum;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    double s_x = ((Point2D)src_pt).getX();
                    double s_y = ((Point2D)src_pt).getY();
                    int s_ix = (int)Math.floor(s_x -= 0.5);
                    int s_iy = (int)Math.floor(s_y -= 0.5);
                    fracx = s_x - (double)s_ix * 1.0;
                    fracy = s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k23;
                        int y0;
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (!this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            if (this.setDestinationNoData) {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataDouble[k23];
                                }
                            }
                        } else {
                            for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                int h;
                                double sum = 0.0;
                                double[][] pixelKernel = new double[4][4];
                                int tmpROI = 0;
                                for (h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcDataArrays[k23][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (tmpROI == 0) {
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataDouble[k23];
                                    continue;
                                }
                                for (h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += pixelKernel[h][z] * this.dataHd[offsetX + z];
                                    }
                                    sum += tempSum * this.dataVd[offsetY + h];
                                }
                                dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = sum;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            if ((fracx += this.fracdx) == 1.0) {
                                fracx = 0.999999f;
                            }
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            if ((fracy += this.fracdy) == 1.0) {
                                fracy = 0.999999f;
                            }
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            double dst_min_x_d = (double)dst_min_x + 0.5;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation(dst_min_x_d, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                double s_x = ((Point2D)src_pt).getX();
                double s_y = ((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x -= 0.5);
                int s_iy = (int)Math.floor(s_y -= 0.5);
                fracx = s_x - (double)s_ix * 1.0;
                fracy = s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    if ((float)s_ix >= src_rect_x11 && (float)s_ix < src_rect_x22 && (float)s_iy >= src_rect_y11 && (float)s_iy < src_rect_y22) {
                        int offsetX = 4 * (int)((double)this.shift * fracx);
                        int offsetY = 4 * (int)((double)this.shift * fracy);
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int pos = posx + posy;
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            double[] bandDataArray = srcDataArrays[k2];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    double value;
                                    pixelKernel[h][z] = value = bandDataArray[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                tempSum = tempData[0] * this.dataHd[offsetX] + tempData[1] * this.dataHd[offsetX + 1] + tempData[2] * this.dataHd[offsetX + 2] + tempData[3] * this.dataHd[offsetX + 3];
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            if (weight == 0) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                                continue;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = sum = tempData[0] * this.dataVd[offsetY] + tempData[1] * this.dataVd[offsetY + 1] + tempData[2] * this.dataVd[offsetY + 2] + tempData[3] * this.dataVd[offsetY + 3];
                            sum = 0.0;
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                double s_x = ((Point2D)src_pt).getX();
                double s_y = ((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x -= 0.5);
                int s_iy = (int)Math.floor(s_y -= 0.5);
                fracx = s_x - (double)s_ix * 1.0;
                fracy = s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k24;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int baseIndex = posx / dst_num_bands + posyROI;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                        if (this.setDestinationNoData) {
                            for (k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataDouble[k24];
                            }
                        }
                    } else {
                        for (k24 = 0; k24 < dst_num_bands; ++k24) {
                            int h;
                            double sum = 0.0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    double value;
                                    pixelKernel[h][z] = value = srcDataArrays[k24][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tmpROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataDouble[k24];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * this.dataHd[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h2 = 0; h2 < 4; ++h2) {
                                sum += tempData[h2] * this.dataVd[offsetY + h2];
                            }
                            dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = sum;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                double s_x = ((Point2D)src_pt).getX();
                double s_y = ((Point2D)src_pt).getY();
                int s_ix = (int)Math.floor(s_x -= 0.5);
                int s_iy = (int)Math.floor(s_y -= 0.5);
                fracx = s_x - (double)s_ix * 1.0;
                fracy = s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 1, 2, 1, 2);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    int y0 = src.getY() + posy / srcScanlineStride;
                    int offsetX = 4 * (int)((double)this.shift * fracx);
                    int offsetY = 4 * (int)((double)this.shift * fracy);
                    int pos = posx + posy;
                    if (!this.roiBounds.contains(x0, y0)) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int h;
                            double sum = 0.0;
                            int tmpROI = 0;
                            for (h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    double value;
                                    pixelKernel[h][z] = value = srcDataArrays[k25][pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tmpROI += roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = !this.noData.contains(value) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tmpROI == 0) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                                continue;
                            }
                            for (h = 0; h < 4; ++h) {
                                double tempSum = 0.0;
                                temp = (byte)(weight >> 4 * h & 0xF);
                                double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                for (int z = 0; z < 4; ++z) {
                                    tempSum += tempData[z] * this.dataHd[offsetX + z];
                                }
                                weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                sumArray[h] = tempSum;
                            }
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            for (int h3 = 0; h3 < 4; ++h3) {
                                sum += tempData[h3] * this.dataVd[offsetY + h3];
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = sum;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        if ((fracx += this.fracdx) == 1.0) {
                            fracx = 0.999999f;
                        }
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        if ((fracy += this.fracdy) == 1.0) {
                            fracy = 0.999999f;
                        }
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private long[] bicubicInpainting(long[] array, short weightSum, long[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        long s_ = array[0];
        long s0 = array[1];
        long s1 = array[2];
        long s2 = array[3];
        emptyArray[0] = 0L;
        emptyArray[1] = 0L;
        emptyArray[2] = 0L;
        emptyArray[3] = 0L;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2L;
                emptyArray[2] = (s_ + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }

    private double[] bicubicInpaintingDouble(double[] array, short weightSum, double[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        double s_ = array[0];
        double s0 = array[1];
        double s1 = array[2];
        double s2 = array[3];
        emptyArray[0] = 0.0;
        emptyArray[1] = 0.0;
        emptyArray[2] = 0.0;
        emptyArray[3] = 0.0;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2.0;
                emptyArray[2] = (s_ + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }
}

