/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.minio.ObjectConditionalReadArgs;
import io.minio.errors.InternalException;

public class ComposeSource
extends ObjectConditionalReadArgs {
    private Long objectSize = null;
    private Multimap<String, String> headers = null;

    protected ComposeSource() {
    }

    public ComposeSource(ObjectConditionalReadArgs args) {
        this.extraHeaders = args.extraHeaders;
        this.extraQueryParams = args.extraQueryParams;
        this.bucketName = args.bucketName;
        this.region = args.region;
        this.objectName = args.objectName;
        this.versionId = args.versionId;
        this.ssec = args.ssec;
        this.offset = args.offset;
        this.length = args.length;
        this.matchETag = args.matchETag;
        this.notMatchETag = args.notMatchETag;
        this.modifiedSince = args.modifiedSince;
        this.unmodifiedSince = args.unmodifiedSince;
    }

    private void throwException(long objectsize, long arg, String argName) {
        StringBuilder builder = new StringBuilder().append("source ").append(this.bucketName).append("/").append(this.objectName);
        if (this.versionId != null) {
            builder.append("?versionId=").append(this.versionId);
        }
        builder.append(": ").append(argName).append(" ").append(arg).append(" is beyond object size ").append(this.objectSize);
        throw new IllegalArgumentException(builder.toString());
    }

    private void validateSize(long objectSize) {
        if (this.offset != null && this.offset >= objectSize) {
            this.throwException(objectSize, this.offset, "offset");
        }
        if (this.length != null) {
            if (this.length > objectSize) {
                this.throwException(objectSize, this.length, "length");
            }
            if (this.offset + this.length > objectSize) {
                this.throwException(objectSize, this.offset + this.length, "compose size");
            }
        }
    }

    public void buildHeaders(long objectSize, String etag) {
        this.validateSize(objectSize);
        this.objectSize = objectSize;
        Multimap<String, String> headers = this.genCopyHeaders();
        if (!headers.containsKey((Object)"x-amz-copy-source-if-match")) {
            headers.put((Object)"x-amz-copy-source-if-match", (Object)etag);
        }
        this.headers = Multimaps.unmodifiableMultimap(headers);
    }

    public long objectSize() throws InternalException {
        if (this.objectSize == null) {
            throw new InternalException("buildHeaders(long objectSize, String etag) must be called prior to this method invocation");
        }
        return this.objectSize;
    }

    public Multimap<String, String> headers() throws InternalException {
        if (this.headers == null) {
            throw new InternalException("buildHeaders(long objectSize, String etag) must be called prior to this method invocation");
        }
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComposeSource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComposeSource that = (ComposeSource)o;
        return Objects.equal((Object)this.objectSize, (Object)that.objectSize) && Objects.equal(this.headers, that.headers);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.objectSize, this.headers});
    }

    public static final class Builder
    extends ObjectConditionalReadArgs.Builder<Builder, ComposeSource> {
    }
}

