/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.util.Assert;

class LettuceScriptingCommands
implements RedisScriptingCommands {
    private final LettuceConnection connection;

    LettuceScriptingCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public void scriptFlush() {
        this.connection.invoke().just(RedisScriptingAsyncCommands::scriptFlush);
    }

    @Override
    public void scriptKill() {
        if (this.connection.isQueueing()) {
            throw new UnsupportedOperationException("Script kill not permitted in a transaction");
        }
        this.connection.invoke().just(RedisScriptingAsyncCommands::scriptKill);
    }

    @Override
    public String scriptLoad(byte[] script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        return (String)this.connection.invoke().just(RedisScriptingAsyncCommands::scriptLoad, script);
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        Assert.notNull((Object)scriptSha1, (String)"Script digests must not be null!");
        Assert.noNullElements((Object[])scriptSha1, (String)"Script digests must not contain null elements!");
        return (List)this.connection.invoke().just(RedisScriptingAsyncCommands::scriptExists, scriptSha1);
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        byte[][] keys = LettuceScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
        byte[][] args = LettuceScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
        String convertedScript = LettuceConverters.toString(script);
        return this.connection.invoke().from(RedisScriptingAsyncCommands::eval, convertedScript, LettuceConverters.toScriptOutputType(returnType), keys, args).get(new LettuceEvalResultsConverter(returnType));
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha1, (String)"Script digest must not be null!");
        byte[][] keys = LettuceScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
        byte[][] args = LettuceScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
        return this.connection.invoke().from(RedisScriptingAsyncCommands::evalsha, scriptSha1, LettuceConverters.toScriptOutputType(returnType), keys, args).get(new LettuceEvalResultsConverter(returnType));
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha1, (String)"Script digest must not be null!");
        return this.evalSha(LettuceConverters.toString(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    private static byte[][] extractScriptKeys(int numKeys, byte[] ... keysAndArgs) {
        if (numKeys > 0) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, 0, numKeys);
        }
        return new byte[0][0];
    }

    private static byte[][] extractScriptArgs(int numKeys, byte[] ... keysAndArgs) {
        if (keysAndArgs.length > numKeys) {
            return (byte[][])Arrays.copyOfRange(keysAndArgs, numKeys, keysAndArgs.length);
        }
        return new byte[0][0];
    }

    private class LettuceEvalResultsConverter<T>
    implements Converter<Object, T> {
        private final ReturnType returnType;

        public LettuceEvalResultsConverter(ReturnType returnType) {
            this.returnType = returnType;
        }

        public T convert(Object source) {
            if (this.returnType == ReturnType.MULTI) {
                List resultList = (List)source;
                for (Object obj : resultList) {
                    if (!(obj instanceof Exception)) continue;
                    throw LettuceScriptingCommands.this.connection.convertLettuceAccessException((Exception)obj);
                }
            }
            return (T)source;
        }
    }
}

