/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.util.Assert;

public class PendingMessagesSummary {
    private final String groupName;
    private final Long totalPendingMessages;
    private final Range<String> idRange;
    private final Map<String, Long> pendingMessagesPerConsumer;

    public PendingMessagesSummary(String groupName, long totalPendingMessages, Range<String> idRange, Map<String, Long> pendingMessagesPerConsumer) {
        Assert.notNull(idRange, (String)"ID Range must not be null");
        Assert.notNull(pendingMessagesPerConsumer, (String)"Pending Messages must not be null");
        this.groupName = groupName;
        this.totalPendingMessages = totalPendingMessages;
        this.idRange = idRange;
        this.pendingMessagesPerConsumer = pendingMessagesPerConsumer;
    }

    public Range<String> getIdRange() {
        return this.idRange;
    }

    public RecordId minRecordId() {
        return RecordId.of(this.minMessageId());
    }

    public RecordId maxRecordId() {
        return RecordId.of(this.maxMessageId());
    }

    public String minMessageId() {
        return (String)this.idRange.getLowerBound().getValue().get();
    }

    public String maxMessageId() {
        return (String)this.idRange.getUpperBound().getValue().get();
    }

    public long getTotalPendingMessages() {
        return this.totalPendingMessages;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Map<String, Long> getPendingMessagesPerConsumer() {
        return Collections.unmodifiableMap(this.pendingMessagesPerConsumer);
    }

    public String toString() {
        return "PendingMessagesSummary{groupName='" + this.groupName + '\'' + ", totalPendingMessages='" + this.getTotalPendingMessages() + '\'' + ", minMessageId='" + this.minMessageId() + '\'' + ", maxMessageId='" + this.maxMessageId() + '\'' + ", pendingMessagesPerConsumer=" + this.pendingMessagesPerConsumer + '}';
    }
}

