/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.springframework.cache.support.NullValue;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GenericJackson2JsonRedisSerializer
implements RedisSerializer<Object> {
    private final ObjectMapper mapper;

    public GenericJackson2JsonRedisSerializer() {
        this((String)null);
    }

    public GenericJackson2JsonRedisSerializer(@Nullable String classPropertyTypeName) {
        this(new ObjectMapper());
        GenericJackson2JsonRedisSerializer.registerNullValueSerializer(this.mapper, classPropertyTypeName);
        if (StringUtils.hasText((String)classPropertyTypeName)) {
            this.mapper.activateDefaultTypingAsProperty(this.mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, classPropertyTypeName);
        } else {
            this.mapper.activateDefaultTyping(this.mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }
    }

    public GenericJackson2JsonRedisSerializer(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        this.mapper = mapper;
    }

    public static void registerNullValueSerializer(ObjectMapper objectMapper, @Nullable String classPropertyTypeName) {
        objectMapper.registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new NullValueSerializer(classPropertyTypeName)));
    }

    @Override
    public byte[] serialize(@Nullable Object source) throws SerializationException {
        if (source == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.mapper.writeValueAsBytes(source);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Could not write JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public Object deserialize(@Nullable byte[] source) throws SerializationException {
        return this.deserialize(source, Object.class);
    }

    @Nullable
    public <T> T deserialize(@Nullable byte[] source, Class<T> type) throws SerializationException {
        Assert.notNull(type, (String)"Deserialization type must not be null! Please provide Object.class to make use of Jackson2 default typing.");
        if (SerializationUtils.isEmpty(source)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(source, type);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    private static class NullValueSerializer
    extends StdSerializer<NullValue> {
        private static final long serialVersionUID = 1999052150548658808L;
        private final String classIdentifier;

        NullValueSerializer(@Nullable String classIdentifier) {
            super(NullValue.class);
            this.classIdentifier = StringUtils.hasText((String)classIdentifier) ? classIdentifier : "@class";
        }

        public void serialize(NullValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField(this.classIdentifier, NullValue.class.getName());
            jgen.writeEndObject();
        }
    }
}

