/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.DoubleFactorSupplier;
import tec.uom.lib.common.function.ValueSupplier;
import tec.uom.se.AbstractConverter;

public final class MultiplyConverter
extends AbstractConverter
implements ValueSupplier<Double>,
DoubleFactorSupplier {
    private static final long serialVersionUID = 6588759878444545649L;
    private double factor;

    public MultiplyConverter(double factor) {
        if (factor == 1.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof MultiplyConverter)) {
            return super.concatenate(converter);
        }
        double newfactor = this.factor * ((MultiplyConverter)converter).factor;
        return newfactor == 1.0 ? IDENTITY : new MultiplyConverter(newfactor);
    }

    @Override
    public MultiplyConverter inverse() {
        return new MultiplyConverter(1.0 / this.factor);
    }

    @Override
    public double convert(double value) {
        return value * this.factor;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(BigDecimal.valueOf(this.factor), ctx);
    }

    public final String toString() {
        return MultiplyConverter.class.getSimpleName() + "(" + this.factor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiplyConverter) {
            MultiplyConverter that = (MultiplyConverter)obj;
            return Objects.equals(this.factor, that.factor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.factor);
    }

    public boolean isLinear() {
        return true;
    }

    public Double getValue() {
        return this.factor;
    }
}

