/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity.time;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.quantity.time.TemporalQuantity;
import tec.uom.se.quantity.time.TimeUnitQuantity;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class TimeQuantities {
    public static final Unit<Time> MICROSECOND = new TransformedUnit<Time>("\u03bcs", Units.SECOND, Units.SECOND, MetricPrefix.MICRO.getConverter());
    public static final TransformedUnit<Time> MILLISECOND = new TransformedUnit<Time>("ms", Units.SECOND, Units.SECOND, MetricPrefix.MILLI.getConverter());
    public static final TransformedUnit<Time> NANOSECOND = new TransformedUnit<Time>("ns", Units.SECOND, Units.SECOND, MetricPrefix.NANO.getConverter());

    private TimeQuantities() {
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Temporal temporalB) {
        long days = ChronoUnit.DAYS.between(temporalA, temporalB);
        return Quantities.getQuantity(days, Units.DAY);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, LocalTime localTimeB) {
        long hours = ChronoUnit.HOURS.between(localTimeA, localTimeB);
        return Quantities.getQuantity(hours, Units.HOUR);
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Supplier<TemporalAdjuster> supplier) {
        Temporal temporalB = temporalA.with(supplier.get());
        return TimeQuantities.getQuantity(temporalA, temporalB);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, Supplier<TemporalAdjuster> supplier) {
        LocalTime localTimeB = localTimeA.with(supplier.get());
        return TimeQuantities.getQuantity(localTimeA, localTimeB);
    }

    public static TimeUnitQuantity getQuantity(Integer number, TimeUnit timeUnit) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TemporalQuantity getQuantity(Integer number, TemporalUnit temporalUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number), Objects.requireNonNull(temporalUnit));
    }

    public static TimeUnitQuantity toTimeUnitSeconds(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().intValue());
    }

    public static TemporalQuantity toTemporalSeconds(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return TemporalQuantity.of((Quantity<Time>)seconds);
    }
}

