/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.Range;
import com.googlecode.aviator.utils.ArrayHashMap;
import com.googlecode.aviator.utils.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Env
implements Map<String, Object> {
    private final Map<String, Object> mDefaults;
    private AviatorEvaluatorInstance instance;
    private Map<String, Object> mOverrides;
    private Expression expression;
    private List<String> importedSymbols;
    private List<String> importedPackages;
    private Map<String, Class<?>> resolvedClasses;
    public static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();

    public Env() {
        this(EMPTY_ENV);
    }

    public Env(Map<String, Object> defaults) {
        this.mDefaults = defaults;
    }

    public Env(Map<String, Object> defaults, Map<String, Object> overrides) {
        this.mDefaults = defaults;
        this.mOverrides = overrides;
    }

    public void setmOverrides(Map<String, Object> mOverrides) {
        this.mOverrides = mOverrides;
    }

    public List<String> getImportedSymbols() {
        return this.importedSymbols;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Map<String, Object> getDefaults() {
        return this.mDefaults;
    }

    public String addSymbol(String sym) {
        if (this.importedSymbols == null) {
            this.importedSymbols = new ArrayList<String>();
        }
        this.importedSymbols.add(sym);
        this.invalidateCache();
        return sym;
    }

    public String addPackageSymbol(String sym) {
        if (this.importedPackages == null) {
            this.importedPackages = new ArrayList<String>();
        }
        this.importedPackages.add(sym);
        this.invalidateCache();
        return sym;
    }

    private void invalidateCache() {
        if (this.resolvedClasses != null) {
            this.resolvedClasses.clear();
        }
    }

    public AviatorEvaluatorInstance getInstance() {
        return this.instance;
    }

    public void setInstance(AviatorEvaluatorInstance instance) {
        this.instance = instance;
    }

    public void configure(AviatorEvaluatorInstance instance, Expression exp) {
        this.instance = instance;
        this.expression = exp;
    }

    private String findSymbol(String name) throws ClassNotFoundException {
        String postfix = "." + name;
        String targetSym = null;
        if (this.importedSymbols != null) {
            for (String sym : this.importedSymbols) {
                if (!sym.endsWith(postfix)) continue;
                targetSym = sym;
                break;
            }
        }
        return targetSym;
    }

    public Class<?> resolveClassSymbol(String name) throws ClassNotFoundException {
        return this.resolveClassSymbol(name, true);
    }

    public Class<?> resolveClassSymbol(String name, boolean checkIfAllow) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name.contains(".")) {
            clazz = this.classForName(name);
            if (clazz != null) {
                return this.checkIfClassIsAllowed(checkIfAllow, clazz);
            }
        } else {
            clazz = this.classForName("java.lang." + name);
            if (clazz != null) {
                return this.checkIfClassIsAllowed(checkIfAllow, clazz);
            }
            clazz = this.retrieveFromCache(name);
            if (clazz != null) {
                return this.checkIfClassIsAllowed(checkIfAllow, clazz);
            }
            clazz = this.resolveFromImportedPackages(name);
            if (clazz != null) {
                return this.checkIfClassIsAllowed(checkIfAllow, clazz);
            }
            if ((clazz = this.resolveFromImportedSymbols(name, clazz)) != null) {
                return this.checkIfClassIsAllowed(checkIfAllow, clazz);
            }
            if (clazz == null && this.mDefaults instanceof Env) {
                clazz = ((Env)this.mDefaults).resolveClassSymbol(name, checkIfAllow);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private Class<?> checkIfClassIsAllowed(boolean checkIfAllow, Class<?> clazz) {
        if (checkIfAllow) {
            Set<Class<?>> allowedList = this.instance.getOptionValue((Options)Options.ALLOWED_CLASS_SET).classes;
            if (allowedList != null && !allowedList.contains(clazz)) {
                throw new ExpressionRuntimeException("`" + clazz + "` is not in allowed class set, check Options.ALLOWED_CLASS_SET");
            }
            Set<Class<?>> assignableList = this.instance.getOptionValue((Options)Options.ASSIGNABLE_ALLOWED_CLASS_SET).classes;
            if (assignableList != null) {
                for (Class<?> aClass : assignableList) {
                    if (!aClass.isAssignableFrom(clazz)) continue;
                    return clazz;
                }
                throw new ExpressionRuntimeException("`" + clazz + "` is not in allowed class set, check Options.ALLOWED_CLASS_SET");
            }
        }
        return clazz;
    }

    private Class<?> resolveFromImportedPackages(String name) {
        Class<?> clazz = null;
        if (this.importedPackages != null) {
            for (String pkg : this.importedPackages) {
                clazz = this.classForName(pkg + name);
                if (clazz == null) continue;
                this.put2cache(name, clazz);
                return clazz;
            }
        }
        return clazz;
    }

    private Class<?> resolveFromImportedSymbols(String name, Class<?> clazz) throws ClassNotFoundException {
        String classSym = this.findSymbol(name);
        if (classSym != null && (clazz = this.classForName(classSym)) != null) {
            this.put2cache(name, clazz);
        }
        return clazz;
    }

    private void put2cache(String name, Class<?> ret) {
        if (this.resolvedClasses == null) {
            this.resolvedClasses = new HashMap();
        }
        this.resolvedClasses.put(name, ret);
    }

    private Class<?> retrieveFromCache(String name) {
        return this.resolvedClasses != null ? this.resolvedClasses.get(name) : null;
    }

    private Class<?> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        if (this.mDefaults != EMPTY_ENV) {
            this.mDefaults.clear();
        }
        if (this.mOverrides != null && this.mOverrides != EMPTY_ENV) {
            this.mOverrides.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Map<String, Object> overrides = this.getmOverrides(true);
        return overrides.containsKey(key) || this.mDefaults != overrides && this.mDefaults.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getmOverrides(true).containsValue(value) || this.mDefaults.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> ret = new HashSet<Map.Entry<String, Object>>(this.mDefaults.entrySet());
        ret.addAll(this.getmOverrides(true).entrySet());
        return ret;
    }

    @Override
    public Object get(Object key) {
        if ("__reducer_loop" == key) {
            return Range.LOOP;
        }
        if ("__reducer_empty" == key) {
            return Constants.REDUCER_EMPTY;
        }
        if ("__env__" == key) {
            this.instance.ensureFeatureEnabled(Feature.InternalVars);
            return this;
        }
        if ("__args__" == key) {
            this.instance.ensureFeatureEnabled(Feature.InternalVars);
            return FunctionUtils.getFunctionArguments(this);
        }
        if ("__instance__" == key) {
            this.instance.ensureFeatureEnabled(Feature.InternalVars);
            return this.instance;
        }
        if ("__exp__" == key) {
            this.instance.ensureFeatureEnabled(Feature.InternalVars);
            return this.expression;
        }
        Map<String, Object> overrides = this.getmOverrides(true);
        Object ret = null;
        ret = overrides.containsKey(key) ? overrides.get(key) : this.mDefaults.get(key);
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.getmOverrides(true).isEmpty() && this.mDefaults.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>(this.mDefaults.keySet());
        ret.addAll(this.getmOverrides(true).keySet());
        return ret;
    }

    public Object override(String key, Object value) {
        Object prior;
        Map<String, Object> overrides = this.getmOverrides(false);
        if (overrides.containsKey(key)) {
            prior = overrides.put(key, value);
        } else {
            overrides.put(key, value);
            prior = this.mDefaults != null ? this.mDefaults.get(key) : null;
        }
        return prior;
    }

    @Override
    public Object put(String key, Object value) {
        Object prior = null;
        Map<String, Object> overrides = this.getmOverrides(false);
        if (overrides.containsKey(key)) {
            prior = overrides.put(key, value);
        } else if (this.mDefaults.containsKey(key)) {
            prior = this.mDefaults.put(key, value);
        } else {
            overrides.put(key, value);
        }
        return prior;
    }

    @Override
    public void putAll(Map map) {
        this.getmOverrides(false).putAll(map);
    }

    @Override
    public Object remove(Object key) {
        if (this.getmOverrides(true).containsKey(key)) {
            return this.getmOverrides(false).remove(key);
        }
        return this.mDefaults.remove(key);
    }

    public Object forgot(Object key) {
        Map<String, Object> overrides = this.getmOverrides(true);
        if (overrides != this.mDefaults && overrides.containsKey(key)) {
            return this.getmOverrides(false).remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (String key : this.keySet()) {
            vals.add(this.get(key));
        }
        return vals;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32 * this.size());
        buf.append(super.toString()).append("{").append("__instance__").append("=").append(this.instance).append(", ").append("__exp__").append("=").append(this.expression).append(", ").append("__env__").append("=").append("<this>");
        Iterator<String> it = this.keySet().iterator();
        boolean hasNext = it.hasNext();
        if (hasNext) {
            buf.append(", ");
        }
        while (hasNext) {
            String key = it.next();
            Object value = this.get(key);
            buf.append(key).append('=').append(value == this ? "<this>" : value);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(',').append(' ');
        }
        buf.append('}');
        return buf.toString();
    }

    private Map<String, Object> getmOverrides(boolean readOnly) {
        if (this.mOverrides == null) {
            if (readOnly) {
                return EMPTY_ENV;
            }
            this.mOverrides = new ArrayHashMap<String, Object>();
        }
        return this.mOverrides;
    }
}

