/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.util.logging.Logger;
import org.geotools.filter.text.commons.FilterToTextUtil;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

class FilterToCQL
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger(FilterToCQL.class);

    FilterToCQL() {
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildExclude(extraData);
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildInclude(extraData);
    }

    public Object visit(And filter, Object extraData) {
        return FilterToTextUtil.buildBinaryLogicalOperator("AND", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        throw new IllegalStateException("Cannot encode an Id as legal CQL");
    }

    public Object visit(Not filter, Object extraData) {
        LOGGER.finer("exporting Not filter");
        return FilterToTextUtil.buildNot(this, filter, extraData);
    }

    public Object visit(Or filter, Object extraData) {
        LOGGER.finer("exporting Or filter");
        return FilterToTextUtil.buildBinaryLogicalOperator("OR", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return FilterToTextUtil.buildBetween(filter, extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "=");
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<>");
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, ">");
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, ">=");
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<");
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, extraData, "<=");
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression());
        return FilterToTextUtil.buildIsLike(filter, extraData);
    }

    private void checkLeftExpressionIsProperty(Expression expr) {
        if (!(expr instanceof PropertyName)) {
            throw new RuntimeException("CQL requires a PropertyName");
        }
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return FilterToTextUtil.buildIsNull(filter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("isNil not supported");
    }

    public Object visit(BBOX filter, Object extraData) {
        return FilterToTextUtil.buildBBOX(filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildDistanceBufferOperation("BEYOND", (DistanceBufferOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("CONTAINS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("CROSSES", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("DISJOINT", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildDWithin(filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("EQUALS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("INTERSECTS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("OVERLAPS", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("TOUCHES", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        this.checkLeftExpressionIsProperty(filter.getExpression1());
        return FilterToTextUtil.buildBinarySpatialOperator("WITHIN", (BinarySpatialOperator)filter, extraData);
    }

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(After after, Object extraData) {
        return FilterToTextUtil.buildBinaryTemporalOperator("AFTER", (BinaryTemporalOperator)after, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return FilterToTextUtil.buildBinaryTemporalOperator("BEFORE", (BinaryTemporalOperator)before, extraData);
    }

    public Object visit(During during, Object extraData) {
        return FilterToTextUtil.buildDuring(during, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter AnyInteracts has not a CQL expression");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Begins has not a CQL expression");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter BegunBy has not a CQL expression");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter EndedBy has not a CQL expression");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Ends has not a CQL expression");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter Meets has not a CQL expression");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter MetBy has not a CQL expression");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter OverlappedBy not implemented");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TContains has not a CQL expression");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TEquals has not a CQL expression");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("Temporal filter TOverlaps has not a CQL expression");
    }
}

