/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class LambertAzimuthalEqualArea
extends MapProjection {
    private static final long serialVersionUID = 1639914708790574760L;
    private static final double EPSILON = 1.0E-7;
    private static final double FINE_EPSILON = 1.0E-10;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    static final int OBLIQUE = 0;
    static final int EQUATORIAL = 1;
    static final int NORTH_POLE = 2;
    static final int SOUTH_POLE = 3;
    final int mode;
    final double sinb1;
    final double cosb1;
    final double xmf;
    final double ymf;
    final double mmf;
    final double qp;
    final double dd;
    final double rq;
    private final double APA0;
    private final double APA1;
    private final double APA2;

    protected LambertAzimuthalEqualArea(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        this.latitudeOfOrigin = this.doubleValue(expected, Provider.LATITUDE_OF_CENTRE, parameters);
        this.centralMeridian = this.doubleValue(expected, Provider.LONGITUDE_OF_CENTRE, parameters);
        LambertAzimuthalEqualArea.ensureLatitudeInRange(Provider.LATITUDE_OF_CENTRE, this.latitudeOfOrigin, true);
        LambertAzimuthalEqualArea.ensureLongitudeInRange(Provider.LONGITUDE_OF_CENTRE, this.centralMeridian, true);
        double t = Math.abs(this.latitudeOfOrigin);
        this.mode = Math.abs(t - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? 3 : 2) : (Math.abs(t) < 1.0E-10 ? 1 : 0);
        double es2 = this.excentricitySquared * this.excentricitySquared;
        double es3 = this.excentricitySquared * es2;
        this.APA0 = 0.10257936507936508 * es3 + 0.17222222222222222 * es2 + 0.3333333333333333 * this.excentricitySquared;
        this.APA1 = 0.0664021164021164 * es3 + 0.06388888888888888 * es2;
        this.APA2 = 0.016415012942191543 * es3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        this.mmf = 0.5 / (1.0 - this.excentricitySquared);
        double sinphi = Math.sin(this.latitudeOfOrigin);
        if (this.isSpherical) {
            this.sinb1 = Math.sin(this.latitudeOfOrigin);
            this.cosb1 = Math.cos(this.latitudeOfOrigin);
        } else {
            this.sinb1 = this.qsfn(sinphi) / this.qp;
            this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                this.dd = 1.0;
                this.xmf = this.ymf = this.rq;
                break;
            }
            case 1: {
                this.dd = 1.0 / this.rq;
                this.xmf = 1.0;
                this.ymf = 0.5 * this.qp;
                break;
            }
            case 0: {
                this.dd = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.excentricitySquared * sinphi * sinphi) * this.rq * this.cosb1);
                this.xmf = this.rq * this.dd;
                this.ymf = this.rq / this.dd;
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        this.set(expected, Provider.LATITUDE_OF_CENTRE, values, this.latitudeOfOrigin);
        this.set(expected, Provider.LONGITUDE_OF_CENTRE, values, this.centralMeridian);
        return values;
    }

    @Override
    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double x;
        double y;
        double c;
        double coslam = Math.cos(lambda);
        double sinlam = Math.sin(lambda);
        double sinphi = Math.sin(phi);
        double q = this.qsfn(sinphi);
        switch (this.mode) {
            case 0: {
                double sinb = q / this.qp;
                double cosb = Math.sqrt(1.0 - sinb * sinb);
                c = 1.0 + this.sinb1 * sinb + this.cosb1 * cosb * coslam;
                double b = Math.sqrt(2.0 / c);
                y = this.ymf * b * (this.cosb1 * sinb - this.sinb1 * cosb * coslam);
                x = this.xmf * b * cosb * sinlam;
                break;
            }
            case 1: {
                double sinb = q / this.qp;
                double cosb = Math.sqrt(1.0 - sinb * sinb);
                c = 1.0 + cosb * coslam;
                double b = Math.sqrt(2.0 / c);
                y = this.ymf * b * sinb;
                x = this.xmf * b * cosb * sinlam;
                break;
            }
            case 2: {
                c = 1.5707963267948966 + phi;
                q = this.qp - q;
                if (q >= 0.0) {
                    double b = Math.sqrt(q);
                    x = b * sinlam;
                    y = coslam * -b;
                    break;
                }
                y = 0.0;
                x = 0.0;
                break;
            }
            case 3: {
                c = phi - 1.5707963267948966;
                q = this.qp + q;
                if (q >= 0.0) {
                    double b = Math.sqrt(q);
                    x = b * sinlam;
                    y = coslam * b;
                    break;
                }
                y = 0.0;
                x = 0.0;
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
        if (Math.abs(c) < 1.0E-10) {
            throw new ProjectionException(168);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double lambda;
        switch (this.mode) {
            case 0: 
            case 1: {
                double ab;
                double rho = Math.hypot(x /= this.dd, y *= this.dd);
                if (rho < 1.0E-10) {
                    lambda = 0.0;
                    phi = this.latitudeOfOrigin;
                    break;
                }
                double sCe = 2.0 * Math.asin(0.5 * rho / this.rq);
                double cCe = Math.cos(sCe);
                sCe = Math.sin(sCe);
                x *= sCe;
                if (this.mode == 0) {
                    ab = cCe * this.sinb1 + y * sCe * this.cosb1 / rho;
                    y = rho * this.cosb1 * cCe - y * this.sinb1 * sCe;
                } else {
                    ab = y * sCe / rho;
                    y = rho * cCe;
                }
                lambda = Math.atan2(x, y);
                phi = this.authlat(Math.asin(ab));
                break;
            }
            case 2: {
                y = -y;
            }
            case 3: {
                double q = x * x + y * y;
                if (q == 0.0) {
                    lambda = 0.0;
                    phi = this.latitudeOfOrigin;
                    break;
                }
                double ab = 1.0 - q / this.qp;
                if (this.mode == 3) {
                    ab = -ab;
                }
                lambda = Math.atan2(x, y);
                phi = this.authlat(Math.asin(ab));
                break;
            }
            default: {
                throw new AssertionError(this.mode);
            }
        }
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    private double qsfn(double sinphi) {
        if (this.excentricity >= 1.0E-7) {
            double con = this.excentricity * sinphi;
            return (1.0 - this.excentricitySquared) * (sinphi / (1.0 - con * con) - 0.5 / this.excentricity * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    private double authlat(double beta) {
        double t = beta + beta;
        return beta + this.APA0 * Math.sin(t) + this.APA1 * Math.sin(t + t) + this.APA2 * Math.sin(t + t + t);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3877793025552244132L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Azimuthal_Equal_Area"), new NamedIdentifier(Citations.EPSG, "Lambert Azimuthal Equal Area"), new NamedIdentifier(Citations.EPSG, "Lambert Azimuthal Equal Area (Spherical)"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertAzimEqualArea"), new NamedIdentifier(Citations.EPSG, "9820")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return Provider.isSpherical(parameters) ? new Spherical(parameters) : new LambertAzimuthalEqualArea(parameters);
        }
    }

    private static final class Spherical
    extends LambertAzimuthalEqualArea {
        private static final long serialVersionUID = 2091431369806844342L;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.ensureSpherical();
        }

        @Override
        protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
            double x;
            double y;
            assert ((ptDst = super.transformNormalized(lambda, phi, ptDst)) != null);
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lambda);
            switch (this.mode) {
                case 1: {
                    y = 1.0 + cosphi * coslam;
                    if (y <= 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    y = Math.sqrt(2.0 / y);
                    x = y * cosphi * Math.sin(lambda);
                    y *= sinphi;
                    break;
                }
                case 0: {
                    y = 1.0 + this.sinb1 * sinphi + this.cosb1 * cosphi * coslam;
                    if (y <= 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    y = Math.sqrt(2.0 / y);
                    x = y * cosphi * Math.sin(lambda);
                    y *= this.cosb1 * sinphi - this.sinb1 * cosphi * coslam;
                    break;
                }
                case 2: {
                    if (Math.abs(phi + this.latitudeOfOrigin) < 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    y = 0.7853981633974483 - phi * 0.5;
                    y = 2.0 * Math.sin(y);
                    x = y * Math.sin(lambda);
                    y *= -coslam;
                    break;
                }
                case 3: {
                    if (Math.abs(phi + this.latitudeOfOrigin) < 1.0E-10) {
                        throw new ProjectionException(168);
                    }
                    y = 0.7853981633974483 - phi * 0.5;
                    y = 2.0 * Math.cos(y);
                    x = y * Math.sin(lambda);
                    y *= coslam;
                    break;
                }
                default: {
                    throw new AssertionError(this.mode);
                }
            }
            assert (Spherical.checkTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double lambda;
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double rh = Math.hypot(x, y);
            double phi = rh * 0.5;
            if (phi > 1.0) {
                throw new ProjectionException(168);
            }
            phi = 2.0 * Math.asin(phi);
            switch (this.mode) {
                case 1: {
                    double sinz = Math.sin(phi);
                    double cosz = Math.cos(phi);
                    phi = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinz / rh);
                    y = cosz * rh;
                    lambda = y == 0.0 ? 0.0 : Math.atan2(x *= sinz, y);
                    break;
                }
                case 0: {
                    double sinz = Math.sin(phi);
                    double cosz = Math.cos(phi);
                    phi = Math.abs(rh) <= 1.0E-10 ? this.latitudeOfOrigin : Math.asin(cosz * this.sinb1 + y * sinz * this.cosb1 / rh);
                    y = (cosz - Math.sin(phi) * this.sinb1) * rh;
                    lambda = y == 0.0 ? 0.0 : Math.atan2(x *= sinz * this.cosb1, y);
                    break;
                }
                case 2: {
                    phi = 1.5707963267948966 - phi;
                    lambda = Math.atan2(x, -y);
                    break;
                }
                case 3: {
                    phi -= 1.5707963267948966;
                    lambda = Math.atan2(x, y);
                    break;
                }
                default: {
                    throw new AssertionError(this.mode);
                }
            }
            assert (Spherical.checkInverseTransform(lambda, phi, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(lambda, phi);
                return ptDst;
            }
            return new Point2D.Double(lambda, phi);
        }
    }
}

