/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import javax.swing.JLabel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.MapPane;
import org.geotools.swing.control.JMapStatusBar;
import org.geotools.swing.control.StatusBarItem;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.locale.LocaleUtils;

public class JExtentStatusBarItem
extends StatusBarItem {
    private static final String COMPONENT_NAME = LocaleUtils.getValue("StatusBar", "ExtentItemName");
    private static final String TOOL_TIP = LocaleUtils.getValue("StatusBar", "ExtentTooltip");
    private static final ReferencedEnvelope EMPTY_ENV = new ReferencedEnvelope();
    private final JLabel label;
    private int decLen;
    private String numFormat;
    private ReferencedEnvelope lastExtent;

    public JExtentStatusBarItem(MapPane mapPane) {
        super(COMPONENT_NAME);
        if (mapPane == null) {
            throw new IllegalArgumentException("mapPane must not be null");
        }
        this.setToolTipText(TOOL_TIP);
        this.lastExtent = EMPTY_ENV;
        this.decLen = 2;
        this.setLabelFormat();
        this.label = new JLabel();
        this.label.setFont(JMapStatusBar.DEFAULT_FONT);
        this.add(this.label);
        mapPane.addMapPaneListener(new MapPaneAdapter(){

            @Override
            public void onDisplayAreaChanged(MapPaneEvent ev) {
                JExtentStatusBarItem.this.displayExtent(ev.getSource().getDisplayArea(), true);
            }
        });
    }

    private void displayExtent(ReferencedEnvelope extent, boolean cache) {
        if (extent == null || extent.isEmpty()) {
            this.label.setText("Undefined extent");
            this.lastExtent = EMPTY_ENV;
        } else {
            this.label.setText(String.format(this.numFormat, extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY()));
            if (cache) {
                this.lastExtent = new ReferencedEnvelope(extent);
            }
        }
    }

    @Override
    public void setNumDecimals(int numDecimals) {
        this.decLen = numDecimals;
        this.setLabelFormat();
        this.displayExtent(this.lastExtent, false);
    }

    private void setLabelFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("x=[%.").append(this.decLen).append("f, ");
        sb.append("%.").append(this.decLen).append("f] ");
        sb.append("y=[%.").append(this.decLen).append("f, ");
        sb.append("%.").append(this.decLen).append("f]");
        this.numFormat = sb.toString();
    }
}

