/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers;

import java.net.URI;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.XMLElementHandler;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.SimpleType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleElementHandler
extends XMLElementHandler {
    private static final long serialVersionUID = SimpleElementHandler.class.hashCode();
    private SimpleType type;
    private Element elem;
    private String text = "";
    private Object value = null;
    private Attributes attr = null;

    public SimpleElementHandler(Element st) {
        this.elem = st;
        this.type = (SimpleType)st.getType();
    }

    @Override
    public Element getElement() {
        return this.elem;
    }

    @Override
    public XMLElementHandler getHandler(URI namespaceURI, String localName, Map hints) throws SAXException {
        throw new SAXException("Should not have any children - this is a simpleType");
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.elem.getName();
    }

    @Override
    public void characters(String text1) {
        this.text = this.text != null ? this.text.concat(text1) : text1;
    }

    @Override
    public void endElement(URI namespaceURI, String localName, Map hints) throws OperationNotSupportedException, SAXException {
        this.text = this.text == null ? null : this.text.trim();
        ElementValue[] vals = new ElementValue[]{new DefaultElementValue(this.text, this.elem)};
        this.value = this.type.getValue(this.elem, vals, this.attr, hints);
        this.attr = null;
        this.text = null;
    }

    @Override
    public void startElement(URI namespaceURI, String localName, Attributes attr1) {
        this.attr = new AttributesImpl(attr1);
    }

    private static class DefaultElementValue
    implements ElementValue {
        private String value = "";
        private Element t;

        public DefaultElementValue(String value, Element t) {
            this.value = value;
            this.t = t;
        }

        @Override
        public Element getElement() {
            return this.t;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

