/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.constant.enums;

import java.util.List;
import org.jeecg.common.util.oConvertUtils;

public enum RoleIndexConfigEnum {
    ADMIN("admin", "dashboard/Analysis"),
    HR("hr", "dashboard/IndexBdc");

    String roleCode;
    String componentUrl;

    private RoleIndexConfigEnum(String roleCode, String componentUrl) {
        this.roleCode = roleCode;
        this.componentUrl = componentUrl;
    }

    private static RoleIndexConfigEnum getEnumByCode(String roleCode) {
        for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
            if (!e.roleCode.equals(roleCode)) continue;
            return e;
        }
        return null;
    }

    private static String getIndexByCode(String roleCode) {
        for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
            if (!e.roleCode.equals(roleCode)) continue;
            return e.componentUrl;
        }
        return null;
    }

    public static String getIndexByRoles(List<String> roles) {
        String[] rolesArray = roles.toArray(new String[roles.size()]);
        for (RoleIndexConfigEnum e : RoleIndexConfigEnum.values()) {
            if (!oConvertUtils.isIn(e.roleCode, rolesArray)) continue;
            return e.componentUrl;
        }
        return null;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getComponentUrl() {
        return this.componentUrl;
    }

    public void setComponentUrl(String componentUrl) {
        this.componentUrl = componentUrl;
    }
}

