/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryBlackListHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryBlackListHandler.class);
    public static Map<String, String> ruleMap = new HashMap<String, String>();

    protected abstract List<QueryTable> getQueryTableInfo(String var1);

    public boolean isPass(String sql) {
        List<QueryTable> list = this.getQueryTableInfo(sql.toLowerCase());
        if (list == null) {
            return true;
        }
        log.info("--\u83b7\u53d6sql\u4fe1\u606f--", (Object)list.toString());
        boolean flag = true;
        for (QueryTable table : list) {
            String name = table.getName();
            String fieldString = ruleMap.get(name);
            if (fieldString == null) continue;
            if ("*".equals(fieldString) || table.isAll()) {
                flag = false;
                log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + name + "\u3011\u7981\u6b62\u67e5\u8be2");
                break;
            }
            if (!table.existSameField(fieldString)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public String getError() {
        return "sql\u9ed1\u540d\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
    }

    static {
        ruleMap.put("sys_user", "password,salt");
    }

    protected class QueryTable {
        private String name;
        private String alias;
        private Set<String> fields;
        private boolean all;

        public QueryTable() {
        }

        public QueryTable(String name, String alias) {
            this.name = name;
            this.alias = alias;
            this.all = false;
            this.fields = new HashSet<String>();
        }

        public void addField(String field) {
            this.fields.add(field);
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getFields() {
            return new HashSet<String>(this.fields);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setFields(Set<String> fields) {
            this.fields = fields;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean isAll() {
            return this.all;
        }

        public void setAll(boolean all) {
            this.all = all;
        }

        public boolean existSameField(String fieldString) {
            String[] arr = fieldString.split(",");
            for (String exp : this.fields) {
                for (String config : arr) {
                    if (exp.equals(config)) {
                        log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + this.name + "\u3011\u4e2d\u5b57\u6bb5\u3010" + config + "\u3011\u7981\u6b62\u67e5\u8be2");
                        return true;
                    }
                    String aliasColumn = config;
                    if (this.alias != null && this.alias.length() > 0) {
                        aliasColumn = this.alias + "." + config;
                    }
                    if (exp.indexOf(aliasColumn) <= 0) continue;
                    log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + this.name + "\u3011\u4e2d\u5b57\u6bb5\u3010" + config + "\u3011\u7981\u6b62\u67e5\u8be2");
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "QueryTable{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", fields=" + this.fields + ", all=" + this.all + '}';
        }
    }
}

