/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.api;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.weibo.dto.WeiboFollowersDto;
import com.jeecg.weibo.exception.BusinessException;
import com.jeecg.weibo.util.HttpUtil;
import com.jeecg.weibo.util.WeiboFollowersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboFriendshipsApi {
    private static final Logger logger = LoggerFactory.getLogger(WeiboFriendshipsApi.class);
    private static final String followers_url = "https://api.weibo.com/2/friendships/followers.json?1=1";
    private static final String followers_url_ids = "https://api.weibo.com/2/friendships/followers/ids.json?1=1";

    public static JSONObject getFollowers(WeiboFollowersDto followers) {
        JSONObject j = null;
        try {
            logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u5217\u8868\u7684\u53c2\u6570\u4e3a:" + followers.toString());
            WeiboFollowersUtil.getFollowersParmValidate(followers);
            String requestUrl = WeiboFollowersUtil.getFollowersUrl(followers_url, followers);
            logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u5217\u8868\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u5217\u8868\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u5217\u8868\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getFollowersIds(WeiboFollowersDto followers) {
        JSONObject j = null;
        try {
            logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1dUID\u5217\u8868\u7684\u53c2\u6570\u4e3a:" + followers.toString());
            WeiboFollowersUtil.getFollowersIdsParmValidate(followers);
            String requestUrl = WeiboFollowersUtil.getFollowersIdsUrl(followers_url_ids, followers);
            logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1dUID\u5217\u8868\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1dUID\u5217\u8868\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u83b7\u53d6\u7528\u6237\u7c89\u4e1dUID\u5217\u8868\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static void main(String[] args) {
    }
}

