/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultConstantPiecewiseTransformElement;
import it.geosolutions.jaiext.piecewise.DefaultDomain1D;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.TransformationException;

public class DefaultPiecewiseTransform1D<T extends DefaultPiecewiseTransform1DElement>
extends DefaultDomain1D<T>
implements PiecewiseTransform1D<T> {
    private boolean hasDefaultValue;
    private double defaultValue;
    private int hashCode = -1;

    public DefaultPiecewiseTransform1D(T[] domainElements, double defaultValue) {
        super(domainElements);
        this.hasDefaultValue = true;
        this.defaultValue = defaultValue;
    }

    public DefaultPiecewiseTransform1D(T[] domainElements) {
        super(domainElements != null && !(domainElements instanceof DefaultConstantPiecewiseTransformElement[]) ? domainElements : null);
    }

    @Override
    public double transform(double value) throws TransformationException {
        DefaultPiecewiseTransform1DElement piece = (DefaultPiecewiseTransform1DElement)this.findDomainElement(value);
        if (piece == null) {
            if (this.hasDefaultValue()) {
                return this.getDefaultValue();
            }
            throw new TransformationException("Error evaluating:" + value);
        }
        return piece.transform(value);
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        PiecewiseUtilities.ensureNonNull("ptSrc", ptSrc);
        if (ptDst == null) {
            ptDst = new Position();
        }
        ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
        return ptDst;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = PiecewiseUtilities.hash(this.defaultValue, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(this.hasDefaultValue, this.hashCode);
        this.hashCode = PiecewiseUtilities.hash(super.hashCode(), this.hashCode);
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DefaultPiecewiseTransform1D) {
            DefaultPiecewiseTransform1D that = (DefaultPiecewiseTransform1D)object;
            if (this.hasDefaultValue != that.hasDefaultValue) {
                return false;
            }
            if (PiecewiseUtilities.equals(this.defaultValue, that.defaultValue)) {
                // empty if block
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultPiecewiseTransform1D.class;
    }
}

