/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.resManager.roleRescatalog.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.resManager.roleRescatalog.entity.RoleRescatalog;
import org.jeecg.modules.resManager.roleRescatalog.service.IRoleRescatalogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u89d2\u8272\u8d44\u6e90\u8868"})
@RestController
@RequestMapping(value={"/resManager.roleRescatalog/roleRescatalog"})
public class RoleRescatalogController
extends JeecgController<RoleRescatalog, IRoleRescatalogService> {
    private static final Logger log = LoggerFactory.getLogger(RoleRescatalogController.class);
    @Autowired
    private IRoleRescatalogService roleRescatalogService;

    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<RoleRescatalog>> queryPageList(RoleRescatalog roleRescatalog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)roleRescatalog, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.roleRescatalogService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u89d2\u8272\u8d44\u6e90\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u6dfb\u52a0", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody RoleRescatalog roleRescatalog) {
        this.roleRescatalogService.save(roleRescatalog);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u89d2\u8272\u8d44\u6e90\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u7f16\u8f91", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody RoleRescatalog roleRescatalog) {
        this.roleRescatalogService.updateById(roleRescatalog);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u89d2\u8272\u8d44\u6e90\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.roleRescatalogService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u89d2\u8272\u8d44\u6e90\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u6279\u91cf\u5220\u9664", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.roleRescatalogService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u89d2\u8272\u8d44\u6e90\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u89d2\u8272\u8d44\u6e90\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<RoleRescatalog> queryById(@RequestParam(name="id", required=true) String id) {
        RoleRescatalog roleRescatalog = (RoleRescatalog)this.roleRescatalogService.getById((Serializable)((Object)id));
        if (roleRescatalog == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)roleRescatalog);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, RoleRescatalog roleRescatalog) {
        return super.exportXls(request, (Object)roleRescatalog, RoleRescatalog.class, "\u89d2\u8272\u8d44\u6e90\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, RoleRescatalog.class);
    }

    @RequestMapping(value={"/queryRoleRescatalog"}, method={RequestMethod.GET})
    public Result<List<String>> queryRoleRescatalog(@RequestParam(name="roleId", required=true) String roleId) {
        Result result = new Result();
        try {
            List list = this.roleRescatalogService.list((Wrapper)new QueryWrapper().lambda().eq(RoleRescatalog::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(RoleRescatalog2 -> String.valueOf(RoleRescatalog2.getRescatalogId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/saveRoleRescatalog"}, method={RequestMethod.POST})
    public Result<String> saveRoleRescatalog(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String roleId = json.getString("roleId");
            String resCatalogIds = json.getString("resCatalogIds");
            String lastRescatalogIds = json.getString("lastRescatalogIds");
            this.roleRescatalogService.saveRolePermission(roleId, resCatalogIds, lastRescatalogIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u89d2\u8272\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

