/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SeqSortFunction
extends AbstractFunction {
    private static final long serialVersionUID = 8105967959099656098L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object first = arg1.getValue(env);
        if (first == null) {
            return AviatorNil.NIL;
        }
        Class<?> clazz = first.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)first;
            Object[] a = list.toArray();
            Arrays.sort(a);
            return AviatorRuntimeJavaType.valueOf(Arrays.asList(a));
        }
        if (clazz.isArray()) {
            int length = Array.getLength(first);
            Object[] dup = (Object[])Array.newInstance(first.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                dup[i] = Array.get(first, i);
            }
            Arrays.sort(dup);
            return AviatorRuntimeJavaType.valueOf(dup);
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not an array or list.");
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        Comparator comparator = (Comparator)arg2.getValue(env);
        if (first == null) {
            return AviatorNil.NIL;
        }
        if (comparator == null) {
            throw new IllegalArgumentException("null comparator");
        }
        Class<?> clazz = first.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)first;
            Object[] a = list.toArray();
            Arrays.sort(a, comparator);
            return AviatorRuntimeJavaType.valueOf(Arrays.asList(a));
        }
        if (clazz.isArray()) {
            int length = Array.getLength(first);
            Object[] dup = (Object[])Array.newInstance(first.getClass().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                dup[i] = Array.get(first, i);
            }
            Arrays.sort(dup, comparator);
            return AviatorRuntimeJavaType.valueOf(dup);
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not an array or list.");
    }

    @Override
    public String getName() {
        return "sort";
    }
}

