/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import it.geosolutions.jaiext.JAIExt;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.RegistryElementDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.ExtendedImagingParameterDescriptors;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class BaseMathOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 6830028735162290160L;
    public static final Logger LOGGER = Logging.getLogger(BaseMathOperationJAI.class);
    public static final String SOURCES_NAME = "Sources";
    public static final ParameterDescriptor SOURCES = new DefaultParameterDescriptor(Citations.JAI, "Sources", Collection.class, null, null, null, null, null, true);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor) {
        super(operationDescriptor, (ParameterDescriptorGroup)new ImagingParameterDescriptors((RegistryElementDescriptor)BaseMathOperationJAI.getOperationDescriptor(operationDescriptor.getName()), REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor, ImagingParameterDescriptors replacements) {
        super(operationDescriptor, (ParameterDescriptorGroup)new ImagingParameterDescriptors(ImagingParameterDescriptors.properties((RegistryElementDescriptor)operationDescriptor), (RegistryElementDescriptor)operationDescriptor, "rendered", ImagingParameterDescriptors.DEFAULT_SOURCE_TYPE_MAP, REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(String name, OperationDescriptor operationDescriptor) {
        super(BaseMathOperationJAI.getOperationDescriptor(JAIExt.getOperationName((String)name)), (ParameterDescriptorGroup)new ExtendedImagingParameterDescriptors(name, (RegistryElementDescriptor)operationDescriptor, new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    public BaseMathOperationJAI(String name) {
        super(BaseMathOperationJAI.getOperationDescriptor(name), (ParameterDescriptorGroup)new ImagingParameterDescriptors((RegistryElementDescriptor)BaseMathOperationJAI.getOperationDescriptor(name), new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    @Override
    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources, String[] sourceNames) throws ParameterNotFoundException, InvalidParameterValueException {
        if (!JAIExt.isJAIExtOperation((String)JAIExt.getOperationName((String)this.getName()))) {
            super.extractSources(parameters, sources, sourceNames);
        } else {
            Utilities.ensureNonNull((String)"parameters", (Object)parameters);
            Utilities.ensureNonNull((String)"sources", sources);
            Object srcCoverages = parameters.parameter(SOURCES_NAME).getValue();
            if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
                throw new InvalidParameterValueException(Errors.format((int)57, (Object)"sources"), "sources", srcCoverages);
            }
            Collection sourceCoverages = (Collection)srcCoverages;
            sources.addAll(sourceCoverages);
        }
    }

    static {
        HashSet<ParameterDescriptor> replacedDescriptors = new HashSet<ParameterDescriptor>();
        replacedDescriptors.add(SOURCES);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }
}

