/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

public final class CharUtilities {
    private CharUtilities() {
    }

    public static boolean isSuperScript(char c) {
        switch (c) {
            case '\u2071': 
            case '\u2072': 
            case '\u2073': {
                return false;
            }
            case '\u00b2': 
            case '\u00b3': 
            case '\u00b9': {
                return true;
            }
        }
        return c >= '\u2070' && c <= '\u207f';
    }

    public static boolean isSubScript(char c) {
        return c >= '\u2080' && c <= '\u208e';
    }

    public static char toSuperScript(char c) {
        switch (c) {
            case '1': {
                return '\u00b9';
            }
            case '2': {
                return '\u00b2';
            }
            case '3': {
                return '\u00b3';
            }
            case '+': {
                return '\u207a';
            }
            case '-': {
                return '\u207b';
            }
            case '=': {
                return '\u207c';
            }
            case '(': {
                return '\u207d';
            }
            case ')': {
                return '\u207e';
            }
            case 'n': {
                return '\u207f';
            }
        }
        if (c >= '0' && c <= '9') {
            return (char)(c + 8256);
        }
        return c;
    }

    public static char toSubScript(char c) {
        switch (c) {
            case '+': {
                return '\u208a';
            }
            case '-': {
                return '\u208b';
            }
            case '=': {
                return '\u208c';
            }
            case '(': {
                return '\u208d';
            }
            case ')': {
                return '\u208e';
            }
        }
        if (c >= '0' && c <= '9') {
            return (char)(c + 8272);
        }
        return c;
    }

    public static char toNormalScript(char c) {
        switch (c) {
            case '\u00b9': {
                return '1';
            }
            case '\u00b2': {
                return '2';
            }
            case '\u00b3': {
                return '3';
            }
            case '\u2071': {
                return c;
            }
            case '\u2072': {
                return c;
            }
            case '\u2073': {
                return c;
            }
            case '\u207a': {
                return '+';
            }
            case '\u207b': {
                return '-';
            }
            case '\u207c': {
                return '=';
            }
            case '\u207d': {
                return '(';
            }
            case '\u207e': {
                return ')';
            }
            case '\u207f': {
                return 'n';
            }
            case '\u208a': {
                return '+';
            }
            case '\u208b': {
                return '-';
            }
            case '\u208c': {
                return '=';
            }
            case '\u208d': {
                return '(';
            }
            case '\u208e': {
                return ')';
            }
        }
        if (c >= '\u2070' && c <= '\u2079') {
            return (char)(c - 8256);
        }
        if (c >= '\u2080' && c <= '\u2089') {
            return (char)(c - 8272);
        }
        return c;
    }
}

