/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotools.util.XArray;

public class LineWriter
extends FilterWriter {
    private String lineSeparator;
    private boolean skipCR;
    private char[] buffer = new char[64];
    private int count = 0;

    public LineWriter(Writer out) {
        this(out, System.getProperty("line.separator", "\n"));
    }

    public LineWriter(Writer out, String lineSeparator) {
        super(out);
        this.lineSeparator = lineSeparator;
        if (out == null || lineSeparator == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineSeparator(String lineSeparator) {
        if (lineSeparator == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lineSeparator = lineSeparator;
        }
    }

    private void writeEOL() throws IOException {
        assert (this.count == 0) : this.count;
        this.out.write(this.lineSeparator);
    }

    private boolean bufferBlank() throws IOException {
        int i = this.count;
        while (--i >= 0) {
            if (this.isWhitespace(this.buffer[i])) continue;
            return false;
        }
        return true;
    }

    private void flushBuffer() throws IOException {
        assert (this.bufferBlank());
        if (this.count != 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    private void writeLine(char[] cbuf, int lower, int upper) throws IOException {
        while (upper != lower) {
            char c = cbuf[upper - 1];
            assert (c != '\r' && c != '\n');
            if (this.isWhitespace(c)) {
                --upper;
                continue;
            }
            this.flushBuffer();
            this.out.write(cbuf, lower, upper - lower);
            return;
        }
        assert (this.bufferBlank());
        this.count = 0;
    }

    private void writeLine(String str, int lower, int upper) throws IOException {
        while (upper != lower) {
            char c = str.charAt(upper - 1);
            assert (c != '\r' && c != '\n');
            if (this.isWhitespace(c)) {
                --upper;
                continue;
            }
            this.flushBuffer();
            this.out.write(str, lower, upper - lower);
            return;
        }
        assert (this.bufferBlank());
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (c) {
                case 13: {
                    assert (this.bufferBlank());
                    this.count = 0;
                    this.writeEOL();
                    this.skipCR = true;
                    break;
                }
                case 10: {
                    if (!this.skipCR) {
                        assert (this.bufferBlank());
                        this.count = 0;
                        this.writeEOL();
                    }
                    this.skipCR = false;
                    break;
                }
                default: {
                    if (c >= 0 && c <= 65535 && this.isWhitespace((char)c)) {
                        if (this.count >= this.buffer.length) {
                            this.buffer = XArray.resize(this.buffer, this.count + Math.min(8192, this.count));
                        }
                        this.buffer[this.count++] = (char)c;
                    } else {
                        this.flushBuffer();
                        this.out.write(c);
                    }
                    this.skipCR = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset + length > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int newCount;
            if (this.skipCR && cbuf[offset] == '\n') {
                ++offset;
                --length;
            }
            int upper = offset;
            while (length != 0) {
                switch (cbuf[upper++]) {
                    case '\r': {
                        this.writeLine(cbuf, offset, upper - 1);
                        this.writeEOL();
                        if (length > 1 && cbuf[upper] == '\n') {
                            --length;
                        }
                        offset = ++upper;
                        break;
                    }
                    case '\n': {
                        this.writeLine(cbuf, offset, upper - 1);
                        this.writeEOL();
                        offset = upper;
                    }
                }
                --length;
            }
            this.skipCR = cbuf[upper - 1] == '\r';
            int i = upper;
            while (--i >= offset) {
                if (this.isWhitespace(cbuf[i])) continue;
                int n = offset;
                offset = i + 1;
                this.writeLine(cbuf, n, offset);
                break;
            }
            if ((newCount = this.count + (length = upper - offset)) > this.buffer.length) {
                this.buffer = XArray.resize(this.buffer, newCount);
            }
            System.arraycopy(cbuf, offset, this.buffer, this.count, length);
            this.count = newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int newCount;
            if (this.skipCR && string.charAt(offset) == '\n') {
                ++offset;
                --length;
            }
            int upper = offset;
            while (length != 0) {
                switch (string.charAt(upper++)) {
                    case '\r': {
                        this.writeLine(string, offset, upper - 1);
                        this.writeEOL();
                        if (length > 1 && string.charAt(upper) == '\n') {
                            --length;
                        }
                        offset = ++upper;
                        break;
                    }
                    case '\n': {
                        this.writeLine(string, offset, upper - 1);
                        this.writeEOL();
                        offset = upper;
                    }
                }
                --length;
            }
            this.skipCR = string.charAt(upper - 1) == '\r';
            int i = upper;
            while (--i >= offset) {
                if (this.isWhitespace(string.charAt(i))) continue;
                int n = offset;
                offset = i + 1;
                this.writeLine(string, n, offset);
                break;
            }
            if ((newCount = this.count + (length = upper - offset)) > this.buffer.length) {
                this.buffer = XArray.resize(this.buffer, newCount);
            }
            while (--length >= 0) {
                this.buffer[this.count++] = string.charAt(offset++);
            }
            assert (this.count == newCount) : newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            super.flush();
        }
    }

    protected boolean isWhitespace(char c) throws IOException {
        return Character.isSpaceChar(c);
    }
}

