/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import javax.measure.format.UnitFormat;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.util.GeoToolsUnitFormat;
import org.opengis.metadata.citation.Citation;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;

abstract class GeoToolsCRSUnitFormat
extends GeoToolsUnitFormat {
    private static final ESRIFormat ESRI = new ESRIFormat();
    private static final EPSGFormat EPSG = new EPSGFormat();

    GeoToolsCRSUnitFormat() {
    }

    public static UnitFormat getInstance(Citation citation) {
        if (CRS.equalsIgnoreMetadata(Citations.ESRI, citation)) {
            return ESRI;
        }
        return EPSG;
    }

    static class ESRIFormat
    extends BaseGT2Format {
        private static final long serialVersionUID = 5769662824845469523L;

        public ESRIFormat() {
            this.initUnits(Units.getDefaultFormat());
            ESRIFormat.esriLabelsAndAliases(this);
        }
    }

    static class EPSGFormat
    extends BaseGT2Format {
        private static final long serialVersionUID = -1207705344688824557L;

        public EPSGFormat() {
            this.initUnits(Units.getDefaultFormat());
            EPSGFormat.epsgLabelsAndAliases(this);
        }
    }

    static class BaseGT2Format
    extends GeoToolsUnitFormat.BaseGT2Format {
        BaseGT2Format() {
        }

        protected static void esriLabelsAndAliases(BaseGT2Format format) {
            format.label(NonSI.DEGREE_ANGLE, "Degree");
            format.label(SI.METRE, "Meter");
            format.label(SI.METRE.multiply(0.3047997101815088), "Foot_Gold_Coast");
            format.label(USCustomary.FOOT, "Foot");
            format.label(USCustomary.FOOT_SURVEY, "Foot_US");
        }

        protected static void epsgLabelsAndAliases(BaseGT2Format format) {
            format.label(NonSI.DEGREE_ANGLE, "degree");
        }
    }
}

