/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.conversantmedia.util.concurrent.PushPullBlockingQueue;
import com.conversantmedia.util.concurrent.SpinPolicy;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.constant.Constable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.ScreenMap;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.GeometryTransformationVisitor;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.filter.visitor.SpatialFilterVisitor;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.OffsetCurveBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.map.DirectLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapContext;
import org.geotools.map.StyleLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.operation.transform.WarpBuilder;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.CompositingGroup;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.DisposableGridCoverage;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.GraphicsAwareDpiRescaleStyleVisitor;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.OpacityFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.renderer.lite.SimpleGeometryFactory;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.lite.SymbolizerAssociation;
import org.geotools.renderer.lite.ZGroupLayer;
import org.geotools.renderer.lite.ZGroupLayerFactory;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.StyleAttributeExtractor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.PolygonSymbolizer;
import org.opengis.style.Rule;

public class StreamingRenderer
implements GTRenderer {
    private static final int REPROJECTION_RASTER_GUTTER = 10;
    private static final int defaultMaxFiltersToSendToDatastore = 5;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    public static final String RENDERING_BUFFER = "renderingBuffer";
    private static final double TOLERANCE = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger(StreamingRenderer.class);
    int error = 0;
    protected static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private static final PropertyName gridPropertyName = filterFactory.property("grid");
    private static final PropertyName paramsPropertyName = filterFactory.property("params");
    private static final PropertyName defaultGeometryPropertyName = filterFactory.property("");
    private MapContent mapContent;
    private boolean interactive = true;
    private boolean concatTransforms = false;
    private ReferencedEnvelope mapExtent;
    private ReferencedEnvelope originalMapExtent;
    private Rectangle screenSize;
    boolean renderingStopRequested = false;
    protected double scaleDenominator;
    private double generalizationDistance = 0.8;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    protected LabelCache labelCache = new LabelCacheImpl();
    protected StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private BlockingQueue<RenderingRequest> requests;
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    private RenderingHints java2dHints;
    private int renderingBufferDEFAULT = 0;
    private String scaleComputationMethodDEFAULT = "OGC";
    public static final String TEXT_RENDERING_STRING = LabelCacheImpl.LabelRenderingMode.STRING.name();
    public static final String TEXT_RENDERING_OUTLINE = LabelCacheImpl.LabelRenderingMode.OUTLINE.name();
    public static final String TEXT_RENDERING_ADAPTIVE = LabelCacheImpl.LabelRenderingMode.ADAPTIVE.name();
    public static final String TEXT_RENDERING_KEY = "textRenderingMethod";
    private String textRenderingModeDEFAULT = TEXT_RENDERING_STRING;
    public static final String LINE_WIDTH_OPTIMIZATION_KEY = "lineWidthOptimization";
    public static final String OPTIMIZE_FTS_RENDERING_KEY = "optimizeFTSRendering";
    public static final String ADVANCED_PROJECTION_HANDLING_KEY = "advancedProjectionHandling";
    public static final String CONTINUOUS_MAP_WRAPPING = "continuousMapWrapping";
    public static final String VECTOR_RENDERING_KEY = "vectorRenderingEnabled";
    private static boolean VECTOR_RENDERING_ENABLED_DEFAULT = false;
    public static final String ADVANCED_PROJECTION_DENSIFICATION_KEY = "advancedProjectionDensificationEnabled";
    private static boolean ADVANCED_PROJECTION_DENSIFICATION_DEFAULT = false;
    public static final String ADVANCED_PROJECTION_DENSIFICATION_TOLERANCE_KEY = "advancedProjectionDensificationTolerance";
    private static double ADVANCED_PROJECTION_DENSIFICATION_TOLERANCE_DEFAULT = 0.8;
    public static final String DATELINE_WRAPPING_HEURISTIC_KEY = "datelineWrappingCheckEnabled";
    private static boolean DATELINE_WRAPPING_HEURISTIC_DEFAULT = true;
    public static final String LABEL_CACHE_KEY = "labelCache";
    public static final String FORCE_EPSG_AXIS_ORDER_KEY = "ForceEPSGAxisOrder";
    public static final String DPI_KEY = "dpi";
    public static final String DECLARED_SCALE_DENOM_KEY = "declaredScaleDenominator";
    public static final String SCALE_COMPUTATION_METHOD_KEY = "scaleComputationMethod";
    public static final String BYLAYER_INTERPOLATION = "byLayerInterpolation";
    private Map rendererHints = null;
    private AffineTransform worldToScreenTransform = null;
    private CoordinateReferenceSystem destinationCrs;
    private boolean canTransform;
    private ExecutorService threadPool;
    private PainterThread painterThread;
    private static int MAX_PIXELS_DENSIFY = Integer.valueOf(System.getProperty("ADVANCED_PROJECTION_DENSIFY_MAX_PIXELS", "5"));
    private static final Decimator NULL_DECIMATOR = new Decimator(-1.0, -1.0);

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setConcatTransforms(boolean flag) {
        this.concatTransforms = flag;
    }

    public boolean getConcatTransforms() {
        return this.concatTransforms;
    }

    @Override
    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
        if (this.labelCache instanceof LabelCacheImpl) {
            ((LabelCacheImpl)this.labelCache).addRenderListener(listener);
        }
    }

    @Override
    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(Object feature) {
        if (!(feature instanceof SimpleFeature)) {
            if (feature instanceof Feature) {
                LOGGER.log(Level.FINE, "Skipping non simple feature rendering notification");
            }
            return;
        }
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.featureRenderer((SimpleFeature)feature);
            }
        }
    }

    private void fireErrorEvent(Throwable t) {
        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
        if (this.renderListeners.size() > 0) {
            Exception e = t instanceof Exception ? (Exception)t : new Exception(t);
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.errorOccurred(e);
            }
        }
    }

    @Override
    public void stopRendering() {
        this.renderingStopRequested = true;
        this.requests.clear();
        this.painterThread.interrupt();
        try {
            this.requests.put(new EndRequest());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to put the end request in the requests queue, this should never happen", e);
        }
        this.labelCache.stop();
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            org.locationtech.jts.geom.Envelope mapArea = RendererUtilities.createMapEnvelope(paintArea, worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(e);
        }
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, org.locationtech.jts.geom.Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform(mapArea, paintArea));
    }

    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, org.locationtech.jts.geom.Envelope mapArea, AffineTransform worldToScreen) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.mapContent.getCoordinateReferenceSystem()), worldToScreen);
    }

    private double computeScale(ReferencedEnvelope envelope, Rectangle paintArea, AffineTransform worldToScreen, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale(envelope, paintArea.width, paintArea.height, hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine(envelope.getCoordinateReferenceSystem(), worldToScreen, hints);
        }
        return RendererUtilities.calculateOGCScale(envelope, paintArea.width, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea, AffineTransform worldToScreen) {
        block86: {
            block85: {
                if (graphics == null) {
                    StreamingRenderer.LOGGER.severe("renderer passed null graphics argument");
                    throw new NullPointerException("renderer requires graphics");
                }
                if (paintArea == null) {
                    StreamingRenderer.LOGGER.severe("renderer passed null paintArea argument");
                    throw new NullPointerException("renderer requires paintArea");
                }
                if (mapArea == null) {
                    StreamingRenderer.LOGGER.severe("renderer passed null mapArea argument");
                    throw new NullPointerException("renderer requires mapArea");
                }
                if (worldToScreen == null && (worldToScreen = RendererUtilities.worldToScreenTransform(mapArea, paintArea)) == null) {
                    return;
                }
                mapCRS = mapArea.getCoordinateReferenceSystem();
                if (CRS.getAxisOrder((CoordinateReferenceSystem)mapCRS) == CRS.AxisOrder.NORTH_EAST) {
                    try {
                        code = CRS.lookupEpsgCode((CoordinateReferenceSystem)mapCRS, (boolean)false);
                        if (code != null) {
                            srs = "EPSG:" + code;
                            earthNorthCRS = CRS.decode((String)srs, (boolean)true);
                            mapArea = new ReferencedEnvelope(mapArea.getMinY(), mapArea.getMaxY(), mapArea.getMinX(), mapArea.getMaxX(), earthNorthCRS);
                        }
                        worldToScreen = new AffineTransform(worldToScreen.getShearX(), worldToScreen.getScaleX(), worldToScreen.getScaleY(), worldToScreen.getShearY(), worldToScreen.getTranslateX(), worldToScreen.getTranslateY());
                    }
                    catch (Exception e) {
                        StreamingRenderer.LOGGER.log(Level.FINER, "Failed to turn the requested bbox in east/north order, map rendering should work anyways, but pay a performance price");
                    }
                }
                this.destinationCrs = mapArea.getCoordinateReferenceSystem();
                this.mapExtent = new ReferencedEnvelope(mapArea);
                this.screenSize = paintArea;
                this.worldToScreenTransform = worldToScreen;
                this.error = 0;
                if (this.java2dHints != null) {
                    graphics.setRenderingHints(this.java2dHints);
                }
                textureAnchor = new Point2D.Double(this.worldToScreenTransform.getTranslateX(), this.worldToScreenTransform.getTranslateY());
                graphics.setRenderingHint(StyledShapePainter.TEXTURE_ANCHOR_HINT_KEY, textureAnchor);
                this.renderingStopRequested = false;
                graphics.setClip(paintArea);
                if (this.concatTransforms) {
                    atg = graphics.getTransform();
                    atg.concatenate(this.worldToScreenTransform);
                    this.worldToScreenTransform = atg;
                    graphics.setTransform(this.worldToScreenTransform);
                }
                this.scaleDenominator = this.computeScale(mapArea, paintArea, this.worldToScreenTransform, this.rendererHints);
                if (StreamingRenderer.LOGGER.isLoggable(Level.FINE)) {
                    StreamingRenderer.LOGGER.fine("Computed scale denominator: " + this.scaleDenominator);
                }
                buffer = this.getRenderingBuffer();
                this.originalMapExtent = this.mapExtent;
                if (buffer > 0) {
                    this.mapExtent = new ReferencedEnvelope(this.expandEnvelope((org.locationtech.jts.geom.Envelope)this.mapExtent, worldToScreen, buffer), this.mapExtent.getCoordinateReferenceSystem());
                }
                this.requests = this.getRequestsQueue();
                this.painterThread = new PainterThread(this.requests);
                localThreadPool = this.threadPool;
                localPool = false;
                if (localThreadPool == null) {
                    localThreadPool = Executors.newSingleThreadExecutor();
                    localPool = true;
                }
                painterFuture = localThreadPool.submit(this.painterThread);
                compositingGroups = null;
                try {
                    if (this.mapContent == null) {
                        throw new IllegalStateException("Cannot call paint, you did not set a MapContent in this renderer");
                    }
                    zGroupedMapContent = ZGroupLayerFactory.filter(this.mapContent);
                    compositingGroups = CompositingGroup.splitOnCompositingBase(graphics, paintArea, zGroupedMapContent);
                    layerCounter = 0;
lbl62:
                    // 4 sources

                    for (CompositingGroup compositingGroup : compositingGroups) {
                        currentMapContent = compositingGroup.mapContent;
                        compositingGraphic = compositingGroup.graphics;
                        this.labelCache.start();
                        if (this.labelCache instanceof LabelCacheImpl) {
                            ((LabelCacheImpl)this.labelCache).setLabelRenderingMode(LabelCacheImpl.LabelRenderingMode.valueOf(this.getTextRenderingMethod()));
                        }
lbl68:
                        // 5 sources

                        for (Layer layer : currentMapContent.layers()) {
                            layerId = String.valueOf(++layerCounter);
                            if (!layer.isVisible()) continue;
                            if (this.renderingStopRequested) {
                                break block85;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl154
                    }
                    break block86;
                }
                catch (Throwable var32_41) {
                    try {
                        if (compositingGroups == null) throw var32_41;
                        for (CompositingGroup group : compositingGroups) {
                            groupContent = group.getMapContent();
                            if (groupContent == this.mapContent) continue;
                            groupContent.dispose();
                        }
                        throw var32_41;
                    }
                    finally {
                        try {
                            if (!this.renderingStopRequested) {
                                this.requests.put(new EndRequest());
                                painterFuture.get();
                            }
                        }
                        catch (Exception e) {
                            painterFuture.cancel(true);
                            this.fireErrorEvent(e);
                        }
                        finally {
                            if (localPool) {
                                localThreadPool.shutdown();
                            }
                        }
                    }
                }
            }
            try {
                if (compositingGroups == null) return;
                for (CompositingGroup group : compositingGroups) {
                    groupContent = group.getMapContent();
                    if (groupContent == this.mapContent) continue;
                    groupContent.dispose();
                }
                return;
            }
            finally {
                try {
                    if (!this.renderingStopRequested) {
                        this.requests.put(new EndRequest());
                        painterFuture.get();
                    }
                }
                catch (Exception e) {
                    painterFuture.cancel(true);
                    this.fireErrorEvent(e);
                }
                finally {
                    if (localPool) {
                        localThreadPool.shutdown();
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                this.labelCache.startLayer(layerId);
                if (layer instanceof DirectLayer) {
                    request = new RenderDirectLayerRequest(compositingGraphic, (DirectLayer)layer);
                    try {
                        this.requests.put(request);
                    }
                    catch (InterruptedException e) {
                        this.fireErrorEvent(e);
                    }
                } else if (layer instanceof ZGroupLayer) {
                    try {
                        zGroup = (ZGroupLayer)layer;
                        zGroup.drawFeatures(compositingGraphic, this, layerId);
                    }
                    catch (Throwable t) {
                        this.fireErrorEvent(t);
                    }
                } else {
                    try {
                        this.processStylers(compositingGraphic, layer, layerId);
                    }
                    catch (Throwable t) {
                        this.fireErrorEvent(t);
                    }
                }
                this.labelCache.endLayer(layerId, graphics, this.screenSize);
                ** GOTO lbl68
lbl154:
                // 1 sources

                if (!(compositingGraphic instanceof DelayedBackbufferGraphic)) ** GOTO lbl62
                request = new MargeCompositingGroupRequest(graphics, compositingGroup);
                try {
                    this.requests.put(request);
                }
                catch (InterruptedException e) {
                    this.fireErrorEvent(e);
                }
                ** GOTO lbl62
            }
        }
        try {
            if (compositingGroups != null) {
                for (CompositingGroup group : compositingGroups) {
                    groupContent = group.getMapContent();
                    if (groupContent == this.mapContent) continue;
                    groupContent.dispose();
                }
            }
        }
        finally {
            try {
                if (!this.renderingStopRequested) {
                    this.requests.put(new EndRequest());
                    painterFuture.get();
                }
            }
            catch (Exception e) {
                painterFuture.cancel(true);
                this.fireErrorEvent(e);
            }
            finally {
                if (localPool) {
                    localThreadPool.shutdown();
                }
            }
        }
        if (!this.renderingStopRequested) {
            this.labelCache.end(graphics, paintArea);
        } else {
            this.labelCache.clear();
        }
        if (StreamingRenderer.LOGGER.isLoggable(Level.FINE)) {
            StreamingRenderer.LOGGER.fine(new StringBuffer("Style cache hit ratio: ").append(this.styleFactory.getHitRatio()).append(" , hits ").append(this.styleFactory.getHits()).append(", requests ").append(this.styleFactory.getRequests()).toString());
        }
        if (this.error <= 0) return;
        StreamingRenderer.LOGGER.warning(new StringBuffer("Number of Errors during paint(Graphics2D, AffineTransform) = ").append(this.error).toString());
    }

    protected BlockingQueue<RenderingRequest> getRequestsQueue() {
        return new RenderingBlockingQueue(10000);
    }

    private org.locationtech.jts.geom.Envelope expandEnvelope(org.locationtech.jts.geom.Envelope envelope, AffineTransform worldToScreen, int buffer) {
        assert (buffer > 0);
        double bufferX = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleX0((AffineTransform)worldToScreen));
        double bufferY = Math.abs((double)buffer * 1.0 / XAffineTransform.getScaleY0((AffineTransform)worldToScreen));
        return new org.locationtech.jts.geom.Envelope(envelope.getMinX() - bufferX, envelope.getMaxX() + bufferX, envelope.getMinY() - bufferY, envelope.getMaxY() + bufferY);
    }

    Query getStyleQuery(Layer layer, List<LiteFeatureTypeStyle> styleList, org.locationtech.jts.geom.Envelope mapArea, CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem featCrs, Rectangle screenSize, GeometryDescriptor geometryAttribute, AffineTransform worldToScreenTransform, boolean hasRenderingTransformation) throws IllegalFilterException, IOException, FactoryException {
        FeatureSource<?, ?> source = layer.getFeatureSource();
        FeatureType schema = source.getSchema();
        Query query = new Query(Query.ALL);
        Filter filter = null;
        if (this.getRenderingBuffer() == 0) {
            int metaBuffer = this.findRenderingBuffer(styleList);
            if (metaBuffer > 0) {
                mapArea = this.expandEnvelope(mapArea, worldToScreenTransform, metaBuffer);
                LOGGER.fine("Expanding rendering area by " + metaBuffer + " pixels to consider stroke width");
                for (LiteFeatureTypeStyle lfts : styleList) {
                    if (lfts.screenMap == null) continue;
                    lfts.screenMap = new ScreenMap(lfts.screenMap, metaBuffer);
                }
            }
            this.setMetaBuffer(styleList, metaBuffer);
        }
        mapArea = this.expandEnvelopeByTransformations(styleList, new ReferencedEnvelope(mapArea, mapCRS));
        List<PropertyName> attributes = styleList == null ? null : this.findStyleAttributes(styleList, schema);
        ReferencedEnvelope envelope = new ReferencedEnvelope(mapArea, mapCRS);
        try {
            List<Object> envelopes = null;
            if (this.isAdvancedProjectionHandlingEnabled()) {
                ProjectionHandler projectionHandler;
                double tolerance;
                HashMap<String, Constable> projectionHints = new HashMap<String, Constable>();
                if (this.isAdvancedProjectionDensificationEnabled() && !CRS.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS) && (tolerance = this.getAdvancedProjectionDensificationTolerance()) > 0.0) {
                    ReferencedEnvelope targetEnvelope = envelope;
                    ReferencedEnvelope sourceEnvelope = this.transformEnvelope(targetEnvelope, featCrs);
                    AffineTransform at = worldToScreenTransform;
                    AffineTransform screenToWorldTransform = new AffineTransform(at);
                    screenToWorldTransform.invert();
                    MathTransform2D crsTransform = (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)featCrs), (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)mapCRS));
                    AffineTransform2D screenTransform = new AffineTransform2D(at);
                    MathTransform2D fullTranform = (MathTransform2D)ConcatenatedTransform.create((MathTransform)crsTransform, (MathTransform)screenTransform);
                    Rectangle2D.Double sourceDomain = new Rectangle2D.Double(sourceEnvelope.getMinX(), sourceEnvelope.getMinY(), sourceEnvelope.getWidth(), sourceEnvelope.getHeight());
                    WarpBuilder wb = new WarpBuilder(tolerance);
                    double densifyDistance = 0.0;
                    int[] actualSplit = wb.isValidDomain(sourceDomain) ? wb.getRowColsSplit(fullTranform, sourceDomain) : null;
                    double minDistance = Math.min((double)MAX_PIXELS_DENSIFY * sourceEnvelope.getWidth() / screenSize.getWidth(), (double)MAX_PIXELS_DENSIFY * sourceEnvelope.getHeight() / screenSize.getHeight());
                    if (actualSplit == null) {
                        densifyDistance = minDistance;
                    } else if (actualSplit[0] != 1 || actualSplit[1] != 1) {
                        densifyDistance = Math.max(Math.min(sourceEnvelope.getWidth() / (double)actualSplit[0], sourceEnvelope.getHeight() / (double)actualSplit[1]), minDistance);
                    }
                    if (densifyDistance > 0.0) {
                        projectionHints.put("advancedProjectionDensify", Double.valueOf(densifyDistance));
                    }
                }
                if (!this.isWrappingHeuristicEnabled()) {
                    projectionHints.put(DATELINE_WRAPPING_HEURISTIC_KEY, Boolean.valueOf(false));
                }
                if ((projectionHandler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)envelope, (CoordinateReferenceSystem)featCrs, (boolean)this.isMapWrappingEnabled(), projectionHints)) != null) {
                    this.setProjectionHandler(styleList, projectionHandler);
                    envelopes = projectionHandler.getQueryEnvelopes();
                }
            }
            if (envelopes == null) {
                envelopes = mapCRS != null && featCrs != null && !CRS.equalsIgnoreMetadata((Object)featCrs, (Object)mapCRS) ? Collections.singletonList(envelope.transform(featCrs, true, 10)) : Collections.singletonList(envelope);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Querying layer " + schema.getName() + " with bbox: " + envelope);
            }
            filter = this.createBBoxFilters(schema, attributes, envelopes);
            query = new Query(schema.getName().getLocalPart());
            query.setFilter(filter);
            query.setProperties(attributes);
            this.processRuleForQuery(styleList, query);
        }
        catch (Exception e) {
            Exception txException = new Exception("Error transforming bbox", e);
            LOGGER.log(Level.SEVERE, "Error querying layer", txException);
            this.fireErrorEvent(txException);
            this.canTransform = false;
            query = new Query(schema.getName().getLocalPart());
            query.setProperties(attributes);
            ReferencedEnvelope bounds = source.getBounds();
            if (bounds != null && envelope.intersects((org.locationtech.jts.geom.Envelope)bounds)) {
                LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, bboxs intersect therefore using envelope)", e);
                filter = null;
                filter = this.createBBoxFilters(schema, attributes, Collections.singletonList(envelope));
                query.setFilter(filter);
            } else {
                LOGGER.log(Level.WARNING, "Got a tranform exception while trying to de-project the current envelope, falling back on full data loading (no bbox query)", e);
                query.setFilter((Filter)Filter.INCLUDE);
            }
            this.processRuleForQuery(styleList, query);
        }
        Object[] sortBy = this.getSortByFromLiteStyles(styleList);
        if (sortBy != null) {
            QueryCapabilities qc = source.getQueryCapabilities();
            if (qc != null && !qc.supportsSorting((SortBy[])sortBy)) {
                throw new IllegalArgumentException("The feature source in layer " + layer.getTitle() + " cannot sort on " + Arrays.toString(sortBy));
            }
            query.setSortBy((SortBy[])sortBy);
        }
        LiteCoordinateSequenceFactory csFactory = new LiteCoordinateSequenceFactory();
        SimpleGeometryFactory gFactory = new SimpleGeometryFactory((CoordinateSequenceFactory)csFactory);
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)csFactory);
        hints.put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)gFactory);
        hints.put((Object)Hints.FEATURE_2D, (Object)Boolean.TRUE);
        try {
            CoordinateReferenceSystem crs = this.getNativeCRS(schema, attributes);
            if (crs != null) {
                Set fsHints = source.getSupportedHints();
                SingleCRS crs2D = crs == null ? null : CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
                MathTransform mt = this.buildFullTransform((CoordinateReferenceSystem)crs2D, mapCRS, worldToScreenTransform);
                double[] spans = Decimator.computeGeneralizationDistances((MathTransform)mt.inverse(), (Rectangle)screenSize, (double)this.generalizationDistance);
                double distance = spans[0] < spans[1] ? spans[0] : spans[1];
                for (LiteFeatureTypeStyle fts : styleList) {
                    if (fts.screenMap == null) continue;
                    fts.screenMap.setTransform(mt);
                    fts.screenMap.setSpans(spans[0], spans[1]);
                    if (!fsHints.contains(Hints.SCREENMAP)) continue;
                    hints.put((Object)Hints.SCREENMAP, (Object)fts.screenMap);
                    fts.screenMap = null;
                }
                if (hasRenderingTransformation) {
                    if (fsHints.contains(Hints.GEOMETRY_GENERALIZATION)) {
                        hints.put((Object)Hints.GEOMETRY_GENERALIZATION, (Object)distance);
                        this.disableInMemoryGeneralization(styleList);
                    }
                } else if (fsHints.contains(Hints.GEOMETRY_SIMPLIFICATION)) {
                    hints.put((Object)Hints.GEOMETRY_SIMPLIFICATION, (Object)distance);
                    this.disableInMemoryGeneralization(styleList);
                } else if (fsHints.contains(Hints.GEOMETRY_DISTANCE)) {
                    hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)distance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error computing the generalization hints", e);
        }
        if (query.getHints() == null) {
            query.setHints(hints);
        } else {
            query.getHints().putAll((Map)hints);
        }
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        simplifier.setFeatureType(source.getSchema());
        Filter simplifiedFilter = (Filter)query.getFilter().accept((FilterVisitor)simplifier, null);
        query.setFilter(simplifiedFilter);
        return query;
    }

    private ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        try {
            ProjectionHandler projectionHandler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)envelope, (CoordinateReferenceSystem)crs, (boolean)this.isMapWrappingEnabled());
            return projectionHandler.getProjectedEnvelope(envelope, crs);
        }
        catch (FactoryException e) {
            return envelope.transform(crs, true);
        }
    }

    private void setMetaBuffer(List<LiteFeatureTypeStyle> styleList, int metaBuffer) {
        for (LiteFeatureTypeStyle fts : styleList) {
            fts.metaBuffer = metaBuffer;
        }
    }

    private void setProjectionHandler(List<LiteFeatureTypeStyle> styleList, ProjectionHandler projectionHandler) {
        for (LiteFeatureTypeStyle fts : styleList) {
            fts.projectionHandler = projectionHandler;
        }
    }

    private void disableInMemoryGeneralization(List<LiteFeatureTypeStyle> styleList) {
        for (LiteFeatureTypeStyle fts : styleList) {
            fts.inMemoryGeneralization = false;
        }
    }

    private SortBy[] getSortByFromLiteStyles(List<LiteFeatureTypeStyle> styles) {
        for (LiteFeatureTypeStyle fts : styles) {
            if (fts.sortBy == null) continue;
            return fts.sortBy;
        }
        return null;
    }

    Query getDefinitionQuery(Layer currLayer, FeatureSource<FeatureType, Feature> source, CoordinateReferenceSystem featCrs) throws FactoryException {
        Query definitionQuery = new Query(this.reprojectQuery(currLayer.getQuery(), source));
        definitionQuery.setCoordinateSystem(featCrs);
        return definitionQuery;
    }

    ReferencedEnvelope expandEnvelopeByTransformations(List<LiteFeatureTypeStyle> styles, ReferencedEnvelope envelope) {
        GeometryTransformationVisitor visitor = new GeometryTransformationVisitor();
        ReferencedEnvelope result = new ReferencedEnvelope(envelope);
        for (LiteFeatureTypeStyle lts : styles) {
            ArrayList<org.geotools.styling.Rule> rules = new ArrayList<org.geotools.styling.Rule>();
            rules.addAll(Arrays.asList(lts.ruleList));
            rules.addAll(Arrays.asList(lts.elseRules));
            for (org.geotools.styling.Rule r : rules) {
                for (Symbolizer s : r.symbolizers()) {
                    ReferencedEnvelope re;
                    if (s.getGeometry() == null || (re = (ReferencedEnvelope)s.getGeometry().accept((ExpressionVisitor)visitor, (Object)envelope)) == null) continue;
                    result.expandToInclude((org.locationtech.jts.geom.Envelope)re);
                }
            }
        }
        return result;
    }

    private MathTransform buildFullTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS, AffineTransform worldToScreenTransform) throws FactoryException {
        Object mt = this.buildTransform(sourceCRS, destCRS);
        mt = mt != null && !mt.isIdentity() ? ConcatenatedTransform.create((MathTransform)mt, (MathTransform)ProjectiveTransform.create((AffineTransform)worldToScreenTransform)) : ProjectiveTransform.create((AffineTransform)worldToScreenTransform);
        return mt;
    }

    private MathTransform buildTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) throws FactoryException {
        MathTransform transform = null;
        if (sourceCRS != null && sourceCRS.getCoordinateSystem().getDimension() >= 3) {
            MathTransform toWgs84_3d = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
            MathTransform toWgs84_2d = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            transform = ConcatenatedTransform.create((MathTransform)toWgs84_3d, (MathTransform)toWgs84_2d);
            sourceCRS = DefaultGeographicCRS.WGS84;
        }
        MathTransform2D mt = sourceCRS == null || destCRS == null || CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS) ? null : (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        if (transform != null) {
            if (mt == null) {
                return transform;
            }
            return ConcatenatedTransform.create(transform, mt);
        }
        return mt;
    }

    private CoordinateReferenceSystem getNativeCRS(FeatureType schema, List<PropertyName> attNames) {
        CoordinateReferenceSystem crs = null;
        for (PropertyName name : attNames) {
            Object att = name.evaluate((Object)schema);
            if (!(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            CoordinateReferenceSystem gdCrs = gd.getCoordinateReferenceSystem();
            if (crs == null) {
                crs = gdCrs;
                continue;
            }
            if (gdCrs == null) {
                crs = null;
                break;
            }
            if (CRS.equalsIgnoreMetadata((Object)crs, (Object)gdCrs)) continue;
            crs = null;
            break;
        }
        return crs;
    }

    private void processRuleForQuery(List<LiteFeatureTypeStyle> styles, Query q) {
        block7: {
            try {
                int maxFilters = this.getMaxFiltersToSendToDatastore();
                ArrayList<Filter> filtersToDS = new ArrayList<Filter>();
                for (LiteFeatureTypeStyle style : styles) {
                    if (style.elseRules.length > 0) {
                        return;
                    }
                    for (org.geotools.styling.Rule r : style.ruleList) {
                        if (r.getFilter() == null) {
                            return;
                        }
                        filtersToDS.add(r.getFilter());
                    }
                }
                if (filtersToDS.size() > maxFilters) {
                    return;
                }
                Object ruleFiltersCombined = filtersToDS.size() == 1 ? (Filter)filtersToDS.get(0) : filterFactory.or(filtersToDS);
                ruleFiltersCombined = filterFactory.and(q.getFilter(), (Filter)ruleFiltersCombined);
                q.setFilter((Filter)ruleFiltersCombined);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.SEVERE, "Could not send rules to datastore due to: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private int getMaxFiltersToSendToDatastore() {
        try {
            if (this.rendererHints == null) {
                return 5;
            }
            Integer result = (Integer)this.rendererHints.get("maxFiltersToSendToDatastore");
            if (result == null) {
                return 5;
            }
            return result;
        }
        catch (Exception e) {
            return 5;
        }
    }

    private boolean isOptimizedFTSRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(OPTIMIZE_FTS_RENDERING_KEY);
        if (result == null) {
            return true;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isAdvancedProjectionHandlingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_HANDLING_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isMapWrappingEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(CONTINUOUS_MAP_WRAPPING);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isEPSGAxisOrderForced() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(FORCE_EPSG_AXIS_ORDER_KEY);
        if (result == null) {
            return false;
        }
        return Boolean.TRUE.equals(result);
    }

    private boolean isVectorRenderingEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(VECTOR_RENDERING_KEY);
        if (result == null) {
            return VECTOR_RENDERING_ENABLED_DEFAULT;
        }
        return (Boolean)result;
    }

    private boolean isAdvancedProjectionDensificationEnabled() {
        if (this.rendererHints == null) {
            return false;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_DENSIFICATION_KEY);
        if (result == null) {
            return ADVANCED_PROJECTION_DENSIFICATION_DEFAULT;
        }
        return (Boolean)result;
    }

    private double getAdvancedProjectionDensificationTolerance() {
        if (this.rendererHints == null) {
            return ADVANCED_PROJECTION_DENSIFICATION_TOLERANCE_DEFAULT;
        }
        Object result = this.rendererHints.get(ADVANCED_PROJECTION_DENSIFICATION_TOLERANCE_KEY);
        if (result == null) {
            return ADVANCED_PROJECTION_DENSIFICATION_TOLERANCE_DEFAULT;
        }
        return (Double)result;
    }

    private boolean isWrappingHeuristicEnabled() {
        if (this.rendererHints == null) {
            return true;
        }
        Object result = this.rendererHints.get(DATELINE_WRAPPING_HEURISTIC_KEY);
        if (result == null) {
            return DATELINE_WRAPPING_HEURISTIC_DEFAULT;
        }
        return (Boolean)result;
    }

    private int findRenderingBuffer(List<LiteFeatureTypeStyle> styles) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        for (LiteFeatureTypeStyle lfts : styles) {
            int j;
            org.geotools.styling.Rule[] rules = lfts.elseRules;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
            rules = lfts.ruleList;
            for (j = 0; j < rules.length; ++j) {
                rbe.visit(rules[j]);
            }
        }
        if (!rbe.isEstimateAccurate()) {
            LOGGER.fine("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually");
        }
        return (int)Math.round((double)rbe.getBuffer() / 2.0 + 1.0);
    }

    private List<PropertyName> findStyleAttributes(List<LiteFeatureTypeStyle> styles, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        for (LiteFeatureTypeStyle lfts : styles) {
            for (org.geotools.styling.Rule exception : lfts.elseRules) {
                sae.visit(exception);
            }
            for (org.geotools.styling.Rule rule : lfts.ruleList) {
                sae.visit(rule);
            }
        }
        if (sae.isUsingDynamincProperties()) {
            return null;
        }
        Set<PropertyName> attributes = sae.getAttributes();
        Set attributeNames = sae.getAttributeNameSet();
        ArrayList<PropertyName> atts = new ArrayList<PropertyName>(attributes);
        Collection attTypes = schema.getDescriptors();
        for (PropertyDescriptor pd : attTypes) {
            Name attName = pd.getName();
            if ((!attName.getLocalPart().equalsIgnoreCase("grid") || attributeNames.contains(attName.getLocalPart())) && (!attName.getLocalPart().equalsIgnoreCase("params") || attributeNames.contains(attName.getLocalPart()))) continue;
            atts.add(filterFactory.property(attName));
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("added attribute " + attName);
        }
        try {
            if (sae.getDefaultGeometryUsed() && !attributeNames.contains(schema.getGeometryDescriptor().getName().toString())) {
                atts.add(filterFactory.property(schema.getGeometryDescriptor().getName()));
            }
            Iterator iterator = atts.iterator();
            while (iterator.hasNext()) {
                PropertyName propertyName = (PropertyName)iterator.next();
                if (!propertyName.getPropertyName().equals("")) continue;
                iterator.remove();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return atts;
    }

    private Filter createBBoxFilters(FeatureType schema, List<PropertyName> attributes, List<ReferencedEnvelope> bboxes) throws IllegalFilterException {
        if (bboxes.isEmpty()) {
            return Filter.EXCLUDE;
        }
        Object filter = Filter.INCLUDE;
        int length = attributes.size();
        for (int j = 0; j < length; ++j) {
            Object attType = attributes.get(j).evaluate((Object)schema);
            if (attType == null || !(attType instanceof GeometryDescriptor)) continue;
            FastBBOX gfilter = new FastBBOX(attributes.get(j), (org.locationtech.jts.geom.Envelope)bboxes.get(0), (FilterFactory)filterFactory);
            filter = filter == Filter.INCLUDE ? gfilter : filterFactory.or((Filter)filter, (Filter)gfilter);
            if (bboxes.size() <= 0) continue;
            for (int k = 1; k < bboxes.size(); ++k) {
                filter = filterFactory.or((Filter)filter, (Filter)new FastBBOX(attributes.get(j), (org.locationtech.jts.geom.Envelope)bboxes.get(k), (FilterFactory)filterFactory));
            }
        }
        return filter;
    }

    private boolean isWithInScale(org.geotools.styling.Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    ArrayList<LiteFeatureTypeStyle> createLiteFeatureTypeStyles(Layer layer, Graphics2D graphics, boolean optimizedFTSRendering) throws IOException, FactoryException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("creating rules for scale denominator - " + NumberFormat.getNumberInstance().format(this.scaleDenominator));
        }
        ArrayList<LiteFeatureTypeStyle> result = new ArrayList<LiteFeatureTypeStyle>();
        boolean foundComposite = false;
        for (FeatureTypeStyle fts : layer.getStyle().featureTypeStyles()) {
            if (!this.isFeatureTypeStyleActive(layer.getFeatureSource().getSchema(), fts)) continue;
            List<List<org.geotools.styling.Rule>> splittedRules = this.splitRules(fts);
            List<org.geotools.styling.Rule> ruleList = splittedRules.get(0);
            List<org.geotools.styling.Rule> elseRuleList = splittedRules.get(1);
            if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
            Composite composite = SLDStyleFactory.getComposite(fts.getOptions());
            LiteFeatureTypeStyle lfts = !(foundComposite |= composite != null) && (result.isEmpty() || !optimizedFTSRendering) ? new LiteFeatureTypeStyle(layer, graphics, ruleList, elseRuleList, fts.getTransformation()) : new LiteFeatureTypeStyle(layer, new DelayedBackbufferGraphic(graphics, this.screenSize), ruleList, elseRuleList, fts.getTransformation());
            lfts.composite = composite;
            if ("first".equals(fts.getOptions().get("ruleEvaluation"))) {
                lfts.matchFirst = true;
            }
            SortBy[] sortBy = SLDStyleFactory.getSortBy(fts.getOptions());
            lfts.sortBy = sortBy;
            if (this.screenMapEnabled(lfts)) {
                int renderingBuffer = this.getRenderingBuffer();
                lfts.screenMap = new ScreenMap(this.screenSize.x - renderingBuffer, this.screenSize.y - renderingBuffer, this.screenSize.width + renderingBuffer * 2, this.screenSize.height + renderingBuffer * 2);
            }
            result.add(lfts);
        }
        if (!result.isEmpty()) {
            this.reprojectSpatialFilters(result, layer.getFeatureSource().getSchema());
            this.applyUnitRescale(result);
        }
        return result;
    }

    boolean screenMapEnabled(LiteFeatureTypeStyle lfts) {
        if (this.generalizationDistance == 0.0) {
            return false;
        }
        OpacityFinder finder = new OpacityFinder(new Class[]{PointSymbolizer.class, LineSymbolizer.class, PolygonSymbolizer.class});
        for (org.geotools.styling.Rule r : lfts.ruleList) {
            r.accept((StyleVisitor)finder);
        }
        for (org.geotools.styling.Rule r : lfts.elseRules) {
            r.accept((StyleVisitor)finder);
        }
        return !finder.hasOpacity;
    }

    private boolean isFeatureTypeStyleActive(FeatureType ftype, FeatureTypeStyle fts) {
        return fts.featureTypeNames().isEmpty() || ftype.getName().getLocalPart() != null && (ftype.getName().getLocalPart().equalsIgnoreCase(fts.getFeatureTypeName()) || FeatureTypes.isDecendedFrom((FeatureType)ftype, null, (String)fts.getFeatureTypeName()));
    }

    private List<List<org.geotools.styling.Rule>> splitRules(FeatureTypeStyle fts) {
        ArrayList<org.geotools.styling.Rule> ruleList = new ArrayList<org.geotools.styling.Rule>();
        ArrayList<org.geotools.styling.Rule> elseRuleList = new ArrayList<org.geotools.styling.Rule>();
        for (org.geotools.styling.Rule r : fts.rules()) {
            if (!this.isWithInScale(r)) continue;
            if (r.isElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            if (!Filter.INCLUDE.equals(r.getFilter()) && this.hasEnvVariables(r.getFilter())) {
                DuplicatingStyleVisitor cloner = new DuplicatingStyleVisitor(){
                    SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();

                    protected Filter copy(Filter filter) {
                        if (filter == null) {
                            return null;
                        }
                        return (Filter)filter.accept((FilterVisitor)this.simplifier, (Object)this.ff);
                    }
                };
                r.accept((StyleVisitor)cloner);
                org.geotools.styling.Rule copy = (org.geotools.styling.Rule)cloner.getCopy();
                if (Filter.EXCLUDE.equals(copy.getFilter())) continue;
                ruleList.add(copy);
                continue;
            }
            ruleList.add(r);
        }
        return Arrays.asList(ruleList, elseRuleList);
    }

    private boolean hasEnvVariables(Filter filter) {
        if (filter == null) {
            return false;
        }
        DefaultFilterVisitor envFunctionChecker = new DefaultFilterVisitor(){

            public Object visit(Function expression, Object data) {
                if (Boolean.TRUE.equals(super.visit(expression, data))) {
                    return true;
                }
                return expression instanceof EnvFunction;
            }
        };
        return Boolean.TRUE.equals(filter.accept((FilterVisitor)envFunctionChecker, null));
    }

    public int getMaxBackBufferMemory(int width, int height) {
        int maxBuffers = 0;
        for (Layer layer : this.mapContent.layers()) {
            StyleLayer styleLayer;
            if (!layer.isVisible() || !(layer instanceof StyleLayer) || (styleLayer = (StyleLayer)layer).getStyle().featureTypeStyles().size() < 2) continue;
            int currCount = 0;
            FeatureType ftype = layer.getFeatureSource().getSchema();
            for (FeatureTypeStyle fts : styleLayer.getStyle().featureTypeStyles()) {
                if (!this.isFeatureTypeStyleActive(ftype, fts)) continue;
                List<List<org.geotools.styling.Rule>> splittedRules = this.splitRules(fts);
                List<org.geotools.styling.Rule> ruleList = splittedRules.get(0);
                List<org.geotools.styling.Rule> elseRuleList = splittedRules.get(1);
                if (ruleList.isEmpty() && elseRuleList.isEmpty()) continue;
                ++currCount;
            }
            if (--currCount <= maxBuffers) continue;
            maxBuffers = currCount;
        }
        return maxBuffers * width * height * 4;
    }

    private void processStylers(Graphics2D graphics, Layer layer, String layerId) throws Exception {
        FeatureSource<?, ?> featureSource = layer.getFeatureSource();
        if (featureSource == null) {
            throw new IllegalArgumentException("The layer does not contain a feature source: " + layer.getTitle());
        }
        FeatureType schema = featureSource.getSchema();
        ArrayList<LiteFeatureTypeStyle> lfts = this.createLiteFeatureTypeStyles(layer, graphics, this.isOptimizedFTSRenderingEnabled());
        if (lfts.isEmpty()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing " + lfts.size() + " stylers for " + schema.getName());
        }
        List<List<LiteFeatureTypeStyle>> txClassified = this.classifyByFeatureProduction(lfts);
        for (List<LiteFeatureTypeStyle> uniform : txClassified) {
            FeatureCollection features = this.getFeatures(layer, schema, uniform);
            if (features == null) continue;
            if (this.isOptimizedFTSRenderingEnabled() && lfts.size() > 1) {
                this.drawOptimized(graphics, layerId, features, uniform);
                continue;
            }
            this.drawPlain(graphics, layerId, features, uniform);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FeatureCollection getFeatures(final Layer layer, FeatureType schema, List<LiteFeatureTypeStyle> featureTypeStyles) throws IOException, FactoryException, NoninvertibleTransformException, SchemaException, TransformException {
        FeatureSource<?, ?> featureSource = layer.getFeatureSource();
        Expression transform = featureTypeStyles.get((int)0).transformation;
        GeometryDescriptor geometryAttribute = schema.getGeometryDescriptor();
        CoordinateReferenceSystem sourceCrs = geometryAttribute != null && geometryAttribute.getType() != null ? geometryAttribute.getType().getCoordinateReferenceSystem() : null;
        boolean hasTransformation = transform != null;
        Query styleQuery = this.getStyleQuery(layer, featureTypeStyles, (org.locationtech.jts.geom.Envelope)this.mapExtent, this.destinationCrs, sourceCrs, this.screenSize, geometryAttribute, this.worldToScreenTransform, hasTransformation);
        Query definitionQuery = this.getDefinitionQuery(layer, featureSource, sourceCrs);
        FeatureCollection features = null;
        if (hasTransformation) {
            RenderingTransformationHelper helper = new RenderingTransformationHelper(){

                @Override
                protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object readParams, GridGeometry2D readGG) throws IOException {
                    Interpolation interpolation = StreamingRenderer.this.getRenderingInterpolation(layer);
                    try {
                        GridCoverageReaderHelper helper = new GridCoverageReaderHelper(reader, (Rectangle)readGG.getGridRange2D(), ReferencedEnvelope.reference((Envelope)readGG.getEnvelope2D()), interpolation);
                        return helper.readCoverage((GeneralParameterValue[])readParams);
                    }
                    catch (InvalidGridGeometryException | FactoryException e) {
                        throw new IOException("Failure reading the coverage", e);
                    }
                }
            };
            GridGeometry2D gridGeometry = this.getRasterGridGeometry(this.destinationCrs, sourceCrs);
            Object result = helper.applyRenderingTransformation(transform, featureSource, definitionQuery, styleQuery, gridGeometry, sourceCrs, this.java2dHints);
            if (result == null) {
                return null;
            }
            if (result instanceof FeatureCollection) {
                features = (FeatureCollection)result;
            } else if (result instanceof GridCoverage2D) {
                GridCoverage2D coverage = (GridCoverage2D)result;
                if (schema instanceof SimpleFeatureType && !FeatureUtilities.isWrappedCoverage((SimpleFeatureType)((SimpleFeatureType)schema))) {
                    coverage = new DisposableGridCoverage(coverage);
                }
                features = FeatureUtilities.wrapGridCoverage((GridCoverage2D)coverage);
            } else {
                if (!(result instanceof GridCoverage2DReader)) throw new IllegalArgumentException("Don't know how to handle the results of the transformation, the supported result types are FeatureCollection, GridCoverage2D and GridCoverage2DReader, but we got: " + result.getClass());
                features = FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)((GridCoverage2DReader)result), null);
            }
        } else {
            Query mixed = DataUtilities.mixQueries((Query)definitionQuery, (Query)styleQuery, null);
            if (styleQuery.getSortBy() != null) {
                mixed.setSortBy(styleQuery.getSortBy());
            } else {
                mixed.setSortBy(definitionQuery.getSortBy());
            }
            this.checkAttributeExistence(featureSource.getSchema(), mixed);
            features = featureSource.getFeatures(mixed);
            features = RendererUtilities.fixFeatureCollectionReferencing(features, sourceCrs);
        }
        if (features instanceof SimpleFeatureCollection) return features;
        features.getSchema().getUserData().put("targetCrs", this.destinationCrs);
        features.getSchema().getUserData().put("targetVersion", "wms:getmap");
        return features;
    }

    List<List<LiteFeatureTypeStyle>> classifyByFeatureProduction(List<LiteFeatureTypeStyle> lfts) {
        ArrayList<List<LiteFeatureTypeStyle>> txClassified = new ArrayList<List<LiteFeatureTypeStyle>>();
        txClassified.add(new ArrayList());
        Expression transformation = null;
        SortBy[] sortBy = null;
        for (int i = 0; i < lfts.size(); ++i) {
            LiteFeatureTypeStyle curr = lfts.get(i);
            if (i == 0) {
                transformation = curr.transformation;
                sortBy = curr.sortBy;
            } else {
                boolean differentTransformation = transformation != curr.transformation || transformation != null && curr.transformation != null && !curr.transformation.equals(transformation);
                boolean incompatibleSort = false;
                if (curr.sortBy != null) {
                    if (sortBy == null) {
                        sortBy = curr.sortBy;
                    } else {
                        incompatibleSort = true;
                    }
                }
                if (differentTransformation || incompatibleSort) {
                    txClassified.add(new ArrayList());
                    transformation = curr.transformation;
                    sortBy = curr.sortBy;
                }
            }
            ((List)txClassified.get(txClassified.size() - 1)).add(curr);
        }
        return txClassified;
    }

    void checkAttributeExistence(FeatureType schema, Query query) {
        if (query.getProperties() == null) {
            return;
        }
        for (PropertyName attribute : query.getProperties()) {
            if (attribute.evaluate((Object)schema) != null) continue;
            if (schema instanceof SimpleFeatureType) {
                ArrayList<Name> allNames = new ArrayList<Name>();
                for (PropertyDescriptor pd : schema.getDescriptors()) {
                    allNames.add(pd.getName());
                }
                throw new IllegalFilterException("Could not find '" + attribute + "' in the FeatureType (" + schema.getName() + "), available attributes are: " + allNames);
            }
            throw new IllegalFilterException("Could not find '" + attribute + "' in the FeatureType (" + schema.getName() + ")");
        }
    }

    void applyUnitRescale(ArrayList<LiteFeatureTypeStyle> lfts) {
        double standardDpi;
        double dpi = RendererUtilities.getDpi(this.getRendererHints());
        if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
            double scaleFactor = dpi / standardDpi;
            GraphicsAwareDpiRescaleStyleVisitor dpiVisitor = new GraphicsAwareDpiRescaleStyleVisitor(scaleFactor);
            for (LiteFeatureTypeStyle fts : lfts) {
                this.rescaleFeatureTypeStyle(fts, (DuplicatingStyleVisitor)dpiVisitor);
            }
        }
        double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio(this.scaleDenominator, this.rendererHints);
        UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
        for (LiteFeatureTypeStyle fts : lfts) {
            this.rescaleFeatureTypeStyle(fts, (DuplicatingStyleVisitor)rescaleVisitor);
        }
    }

    void reprojectSpatialFilters(ArrayList<LiteFeatureTypeStyle> lfts, FeatureType schema) throws FactoryException {
        CoordinateReferenceSystem declaredCRS = this.getDeclaredSRS(schema);
        for (LiteFeatureTypeStyle fts : lfts) {
            this.reprojectSpatialFilters(fts, declaredCRS, schema);
        }
    }

    private CoordinateReferenceSystem getDeclaredSRS(FeatureType schema) throws FactoryException {
        Integer code;
        CoordinateReferenceSystem declaredCRS = schema.getCoordinateReferenceSystem();
        if (this.isEPSGAxisOrderForced() && (code = CRS.lookupEpsgCode((CoordinateReferenceSystem)declaredCRS, (boolean)false)) != null) {
            declaredCRS = CRS.decode((String)("urn:ogc:def:crs:EPSG::" + code));
        }
        return declaredCRS;
    }

    private Query reprojectQuery(Query query, FeatureSource<FeatureType, Feature> source) throws FactoryException {
        if (query == null || query.getFilter() == null) {
            return query;
        }
        Filter original = query.getFilter();
        CoordinateReferenceSystem declaredCRS = this.getDeclaredSRS(source.getSchema());
        Filter reprojected = this.reprojectSpatialFilter(declaredCRS, source.getSchema(), original);
        if (reprojected == original) {
            return query;
        }
        Query rq = new Query(query);
        rq.setFilter(reprojected);
        return rq;
    }

    void reprojectSpatialFilters(LiteFeatureTypeStyle fts, CoordinateReferenceSystem declaredCRS, FeatureType schema) {
        int i;
        for (i = 0; i < fts.ruleList.length; ++i) {
            fts.ruleList[i] = this.reprojectSpatialFilters(fts.ruleList[i], declaredCRS, schema);
        }
        if (fts.elseRules != null) {
            for (i = 0; i < fts.elseRules.length; ++i) {
                fts.elseRules[i] = this.reprojectSpatialFilters(fts.elseRules[i], declaredCRS, schema);
            }
        }
    }

    private org.geotools.styling.Rule reprojectSpatialFilters(org.geotools.styling.Rule rule, CoordinateReferenceSystem declaredCRS, FeatureType schema) {
        Filter filter = rule.getFilter();
        if (filter == null) {
            return rule;
        }
        Filter reprojected = this.reprojectSpatialFilter(declaredCRS, schema, filter);
        if (reprojected == filter) {
            return rule;
        }
        RuleImpl rr = new RuleImpl((Rule)rule);
        rr.setFilter(reprojected);
        return rr;
    }

    private Filter reprojectSpatialFilter(CoordinateReferenceSystem declaredCRS, FeatureType schema, Filter filter) {
        if (filter == null) {
            return null;
        }
        SpatialFilterVisitor sfv = new SpatialFilterVisitor();
        filter.accept((FilterVisitor)sfv, null);
        if (!sfv.hasSpatialFilter()) {
            return filter;
        }
        DefaultCRSFilterVisitor defaulter = new DefaultCRSFilterVisitor(filterFactory, declaredCRS);
        Filter defaulted = (Filter)filter.accept((FilterVisitor)defaulter, null);
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(filterFactory, schema);
        Filter reprojected = (Filter)defaulted.accept((FilterVisitor)reprojector, null);
        return reprojected;
    }

    void rescaleFeatureTypeStyle(LiteFeatureTypeStyle fts, DuplicatingStyleVisitor visitor) {
        int i;
        for (i = 0; i < fts.ruleList.length; ++i) {
            visitor.visit(fts.ruleList[i]);
            fts.ruleList[i] = (org.geotools.styling.Rule)visitor.getCopy();
        }
        if (fts.elseRules != null) {
            for (i = 0; i < fts.elseRules.length; ++i) {
                visitor.visit(fts.elseRules[i]);
                fts.elseRules[i] = (org.geotools.styling.Rule)visitor.getCopy();
            }
        }
    }

    private void drawPlain(Graphics2D graphics, String layerId, FeatureCollection<?, ?> features, List<LiteFeatureTypeStyle> lfts) {
        for (LiteFeatureTypeStyle liteFeatureTypeStyle : lfts) {
            try (FeatureIterator featureIterator = features.features();){
                if (featureIterator == null) {
                    return;
                }
                boolean cloningRequired = this.isCloningRequired(lfts);
                RenderableFeature rf = this.createRenderableFeature(layerId, cloningRequired);
                rf.layer = liteFeatureTypeStyle.layer;
                rf.setScreenMap(liteFeatureTypeStyle.screenMap);
                while (featureIterator.hasNext() && !this.renderingStopRequested) {
                    rf.setFeature(featureIterator.next());
                    this.processFeature(rf, liteFeatureTypeStyle);
                }
            }
            if (liteFeatureTypeStyle.composite == null) continue;
            try {
                this.requests.put(new MergeLayersRequest(graphics, Collections.singletonList(liteFeatureTypeStyle)));
            }
            catch (InterruptedException e) {
                this.fireErrorEvent(e);
            }
        }
    }

    RenderableFeature createRenderableFeature(String layerId, boolean cloningRequired) {
        RenderableFeature rf = new RenderableFeature(layerId, cloningRequired);
        return rf;
    }

    private void drawOptimized(Graphics2D graphics, String layerId, FeatureCollection features, List<LiteFeatureTypeStyle> lfts) {
        try (FeatureIterator iterator = features.features();){
            if (iterator == null) {
                return;
            }
            boolean cloningRequired = this.isCloningRequired(lfts);
            RenderableFeature rf = this.createRenderableFeature(layerId, cloningRequired);
            while (iterator.hasNext() && !this.renderingStopRequested) {
                rf.setFeature(iterator.next());
                for (LiteFeatureTypeStyle liteFeatureTypeStyle : lfts) {
                    this.processFeature(rf, liteFeatureTypeStyle);
                }
            }
            this.requests.put(new MergeLayersRequest(graphics, lfts));
        }
        catch (InterruptedException e) {
            this.fireErrorEvent(e);
        }
    }

    private boolean isCloningRequired(List<LiteFeatureTypeStyle> lfts) {
        Layer layer = lfts.get((int)0).layer;
        Set hints = layer.getFeatureSource().getSupportedHints();
        if (!hints.contains(Hints.FEATURE_DETACHED)) {
            return true;
        }
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        FeatureType featureType = layer.getFeatureSource().getSchema();
        HashSet<String> plainGeometries = new HashSet<String>();
        HashSet<String> txGeometries = new HashSet<String>();
        for (LiteFeatureTypeStyle liteFeatureTypeStyle : lfts) {
            for (org.geotools.styling.Rule r : liteFeatureTypeStyle.ruleList) {
                for (Symbolizer s : r.symbolizers()) {
                    String attribute;
                    if (s.getGeometry() == null) {
                        attribute = featureType.getGeometryDescriptor().getName().getLocalPart();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    if (s.getGeometry() instanceof PropertyName) {
                        attribute = ((PropertyName)s.getGeometry()).getPropertyName();
                        if (txGeometries.contains(attribute)) {
                            return true;
                        }
                        plainGeometries.add(attribute);
                        continue;
                    }
                    Expression g = s.getGeometry();
                    extractor.clear();
                    g.accept((ExpressionVisitor)extractor, null);
                    Set attributes = extractor.getAttributeNameSet();
                    for (String attribute2 : attributes) {
                        if (plainGeometries.contains(attribute2)) {
                            return true;
                        }
                        if (txGeometries.contains(attribute2)) {
                            return true;
                        }
                        txGeometries.add(attribute2);
                    }
                }
            }
        }
        StyleAttributeExtractor extractorOther = new StyleAttributeExtractor();
        extractorOther.setSymbolizerGeometriesVisitEnabled(false);
        for (LiteFeatureTypeStyle lft : lfts) {
            for (org.geotools.styling.Rule r : lft.ruleList) {
                if (r.getFilter() != null) {
                    r.getFilter().accept((FilterVisitor)extractorOther, null);
                }
                for (Symbolizer s : r.symbolizers()) {
                    s.accept((StyleVisitor)extractorOther);
                }
            }
        }
        Set set = extractorOther.getAttributes().stream().map(pn -> pn.getPropertyName()).collect(Collectors.toSet());
        if (extractorOther.getDefaultGeometryUsed() && featureType.getGeometryDescriptor() != null) {
            String defaultGeometryName = featureType.getGeometryDescriptor().getName().getLocalPart();
            set.add(defaultGeometryName);
        }
        return !Collections.disjoint(set, plainGeometries) || !Collections.disjoint(set, txGeometries);
    }

    void processFeature(RenderableFeature rf, LiteFeatureTypeStyle fts) {
        try {
            rf.inMemoryGeneralization = fts.inMemoryGeneralization;
            rf.projectionHandler = fts.projectionHandler;
            rf.setScreenMap(fts.screenMap);
            rf.layer = fts.layer;
            rf.metaBuffer = fts.metaBuffer;
            boolean doElse = true;
            org.geotools.styling.Rule[] elseRuleList = fts.elseRules;
            org.geotools.styling.Rule[] ruleList = fts.ruleList;
            Graphics2D graphics = fts.graphics;
            int length = ruleList.length;
            int paintCommands = 0;
            for (int t = 0; t < length; ++t) {
                org.geotools.styling.Rule r = ruleList[t];
                Filter filter = r.getFilter();
                if (filter != null && !filter.evaluate((Object)rf.feature)) continue;
                doElse = false;
                paintCommands += this.processSymbolizers(graphics, rf, r.symbolizers());
                if (fts.matchFirst) break;
            }
            if (doElse) {
                for (org.geotools.styling.Rule r : elseRuleList) {
                    paintCommands += this.processSymbolizers(graphics, rf, r.symbolizers());
                }
            }
            if (paintCommands > 0) {
                this.requests.put(new FeatureRenderedRequest(rf.feature));
            }
        }
        catch (Throwable tr) {
            this.fireErrorEvent(tr);
        }
    }

    private int processSymbolizers(Graphics2D graphics, RenderableFeature drawMe, List<Symbolizer> symbolizers) throws Exception {
        int paintCommands = 0;
        for (Symbolizer symbolizer : symbolizers) {
            if (symbolizer instanceof RasterSymbolizer) {
                GridCoverage2D coverage = null;
                boolean disposeCoverage = false;
                try {
                    Object grid = gridPropertyName.evaluate((Object)drawMe.feature);
                    if (grid instanceof GridCoverage2D) {
                        coverage = (GridCoverage2D)grid;
                        if (coverage == null) continue;
                        disposeCoverage = grid instanceof DisposableGridCoverage;
                        this.requests.put(new RenderRasterRequest(graphics, coverage, disposeCoverage, (RasterSymbolizer)symbolizer, this.destinationCrs, this.worldToScreenTransform));
                        ++paintCommands;
                        continue;
                    }
                    if (!(grid instanceof GridCoverage2DReader)) continue;
                    GeneralParameterValue[] params = (GeneralParameterValue[])paramsPropertyName.evaluate((Object)drawMe.feature);
                    GridCoverage2DReader reader = (GridCoverage2DReader)grid;
                    this.requests.put(new RenderCoverageReaderRequest(graphics, reader, params, (RasterSymbolizer)symbolizer, this.destinationCrs, this.worldToScreenTransform, this.getRenderingInterpolation(drawMe.layer)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    this.fireErrorEvent(e);
                }
                continue;
            }
            LiteShape2 shape = drawMe.getShape(symbolizer, this.worldToScreenTransform);
            if (shape == null) continue;
            if (symbolizer instanceof TextSymbolizer && drawMe.feature instanceof Feature) {
                this.labelCache.put(drawMe.layerId, (TextSymbolizer)symbolizer, drawMe.feature, shape, null);
                ++paintCommands;
                continue;
            }
            Style2D style = this.styleFactory.createStyle(drawMe.feature, symbolizer);
            double size = RendererUtilities.getStyle2DSize(style);
            double clipBuffer = Math.max(size / 2.0, (double)drawMe.metaBuffer) + 10.0;
            org.locationtech.jts.geom.Envelope env = new org.locationtech.jts.geom.Envelope(this.screenSize.getMinX(), this.screenSize.getMaxX(), this.screenSize.getMinY(), this.screenSize.getMaxY());
            env.expandBy(clipBuffer);
            GeometryClipper clipper = new GeometryClipper(env);
            Geometry source = shape.getGeometry();
            boolean preserveTopology = style instanceof LineStyle2D && ((LineStyle2D)style).getPerpendicularOffset() != 0.0 && (source instanceof Polygon || source instanceof MultiPolygon);
            Geometry g = clipper.clipSafe(shape.getGeometry(), preserveTopology, 1.0);
            if (style instanceof LineStyle2D && ((LineStyle2D)style).getPerpendicularOffset() != 0.0 && g != null && !g.isEmpty()) {
                LineStyle2D ls = (LineStyle2D)style;
                double offset = ls.getPerpendicularOffset();
                if ((source instanceof Polygon || source instanceof MultiPolygon) && Math.abs(offset) > 3.0) {
                    Geometry simplified = TopologyPreservingSimplifier.simplify((Geometry)source, (double)Math.max(Math.abs(offset) / 10.0, 1.0));
                    try {
                        g = simplified.buffer(offset);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failed to apply JTS buffer to the geometry, falling back on the offset curve builder", e);
                        OffsetCurveBuilder offseter = new OffsetCurveBuilder(offset);
                        g = offseter.offset(g);
                    }
                } else {
                    OffsetCurveBuilder offseter = new OffsetCurveBuilder(offset);
                    g = offseter.offset(g);
                }
            }
            if (g == null) continue;
            shape = new LiteShape2(g, null, null, false);
            PaintShapeRequest paintShapeRequest = new PaintShapeRequest(graphics, shape, style, this.scaleDenominator);
            if (symbolizer.hasOption("labelObstacle")) {
                paintShapeRequest.setLabelObstacle(true);
            }
            this.requests.put(paintShapeRequest);
            ++paintCommands;
        }
        return paintCommands;
    }

    GridGeometry2D getRasterGridGeometry(CoordinateReferenceSystem destinationCrs, CoordinateReferenceSystem sourceCRS) throws NoninvertibleTransformException {
        GridGeometry2D readGG;
        if (sourceCRS == null || destinationCrs == null || CRS.equalsIgnoreMetadata((Object)destinationCrs, (Object)sourceCRS)) {
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.screenSize), (Envelope)this.originalMapExtent);
        } else {
            Rectangle bufferedTargetArea = (Rectangle)this.screenSize.clone();
            bufferedTargetArea.add(this.screenSize.x + this.screenSize.width + 10, this.screenSize.y + this.screenSize.height + 10);
            bufferedTargetArea.add(this.screenSize.x - 10, this.screenSize.y - 10);
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, (MathTransform)new AffineTransform2D(this.worldToScreenTransform.createInverse()), this.originalMapExtent.getCoordinateReferenceSystem(), null);
        }
        return readGG;
    }

    private Geometry findGeometry(Object drawMe, Symbolizer s) {
        Expression geomExpr = s.getGeometry();
        Geometry geom = geomExpr == null ? (drawMe instanceof SimpleFeature ? (Geometry)((SimpleFeature)drawMe).getDefaultGeometry() : (drawMe instanceof Feature ? (Geometry)((Feature)drawMe).getDefaultGeometryProperty().getValue() : (Geometry)defaultGeometryPropertyName.evaluate(drawMe, Geometry.class))) : (Geometry)geomExpr.evaluate(drawMe, Geometry.class);
        return geom;
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        FeatureType schema = f.getType();
        Expression geometry = s.getGeometry();
        if (geometry instanceof PropertyName) {
            return this.getAttributeCRS((PropertyName)geometry, schema);
        }
        if (geometry == null) {
            return this.getAttributeCRS(null, schema);
        }
        StyleAttributeExtractor attExtractor = new StyleAttributeExtractor();
        geometry.accept((ExpressionVisitor)attExtractor, null);
        for (PropertyName name : attExtractor.getAttributes()) {
            if (!(name.evaluate((Object)schema) instanceof GeometryDescriptor)) continue;
            return this.getAttributeCRS(name, schema);
        }
        return null;
    }

    CoordinateReferenceSystem getAttributeCRS(PropertyName geomName, FeatureType schema) {
        if (geomName == null || "".equals(geomName.getPropertyName())) {
            GeometryDescriptor geom = schema.getGeometryDescriptor();
            return geom.getType().getCoordinateReferenceSystem();
        }
        GeometryDescriptor geom = (GeometryDescriptor)geomName.evaluate((Object)schema);
        return geom.getType().getCoordinateReferenceSystem();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    private int getRenderingBuffer() {
        if (this.rendererHints == null) {
            return this.renderingBufferDEFAULT;
        }
        Number result = (Number)this.rendererHints.get(RENDERING_BUFFER);
        if (result == null) {
            return this.renderingBufferDEFAULT;
        }
        return result.intValue();
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get(SCALE_COMPUTATION_METHOD_KEY);
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    private String getTextRenderingMethod() {
        if (this.rendererHints == null) {
            return this.textRenderingModeDEFAULT;
        }
        String result = (String)this.rendererHints.get(TEXT_RENDERING_KEY);
        if (result == null) {
            return this.textRenderingModeDEFAULT;
        }
        return result;
    }

    public double getGeneralizationDistance() {
        return this.generalizationDistance;
    }

    public void setGeneralizationDistance(double d) {
        this.generalizationDistance = d;
    }

    @Override
    public void setJava2DHints(RenderingHints hints) {
        this.java2dHints = hints;
        this.styleFactory.setRenderingHints(hints);
    }

    @Override
    public RenderingHints getJava2DHints() {
        return this.java2dHints;
    }

    public void setRendererHints(Map hints) {
        if (hints != null && hints.containsKey(LABEL_CACHE_KEY)) {
            LabelCache cache = (LabelCache)hints.get(LABEL_CACHE_KEY);
            if (cache == null) {
                throw new NullPointerException("Label_Cache_Hint has a null value for the labelcache");
            }
            this.labelCache = cache;
            this.painter = new StyledShapePainter(cache);
        }
        if (hints != null && hints.containsKey(LINE_WIDTH_OPTIMIZATION_KEY)) {
            this.styleFactory.setLineOptimizationEnabled(Boolean.TRUE.equals(hints.get(LINE_WIDTH_OPTIMIZATION_KEY)));
        }
        this.rendererHints = hints;
        this.styleFactory.setVectorRenderingEnabled(this.isVectorRenderingEnabled());
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    @Override
    public void setContext(MapContext context) {
        this.mapContent = context;
    }

    @Override
    public MapContext getContext() {
        if (this.mapContent instanceof MapContext) {
            return (MapContext)this.mapContent;
        }
        MapContext context = new MapContext(this.mapContent);
        return context;
    }

    @Override
    public void setMapContent(MapContent mapContent) {
        this.mapContent = mapContent;
    }

    @Override
    public MapContent getMapContent() {
        return this.mapContent;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public static MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem destCRS) {
        try {
            return CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
        }
        catch (OperationNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    Interpolation getRenderingInterpolation(Layer currLayer) {
        if (currLayer != null && currLayer.getUserData().containsKey(BYLAYER_INTERPOLATION)) {
            return (Interpolation)currLayer.getUserData().get(BYLAYER_INTERPOLATION);
        }
        if (this.java2dHints == null) {
            return Interpolation.getInstance((int)0);
        }
        Object interpolationHint = this.java2dHints.get(RenderingHints.KEY_INTERPOLATION);
        if (interpolationHint == null || interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
            return Interpolation.getInstance((int)0);
        }
        if (interpolationHint == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
            return Interpolation.getInstance((int)1);
        }
        return Interpolation.getInstance((int)2);
    }

    public class RenderingBlockingQueue
    implements BlockingQueue<RenderingRequest> {
        private static final long serialVersionUID = 4908029658595573833L;
        PushPullBlockingQueue<RenderingRequest> delegate;

        public RenderingBlockingQueue(int capacity) {
            this.delegate = new PushPullBlockingQueue(capacity, SpinPolicy.BLOCKING);
        }

        @Override
        public boolean add(RenderingRequest renderingRequest) {
            return this.delegate.add((Object)renderingRequest);
        }

        @Override
        public boolean offer(RenderingRequest renderingRequest) {
            return this.delegate.offer((Object)renderingRequest);
        }

        @Override
        public RenderingRequest remove() {
            return (RenderingRequest)this.delegate.remove();
        }

        @Override
        public RenderingRequest poll() {
            return (RenderingRequest)this.delegate.poll();
        }

        @Override
        public RenderingRequest element() {
            return (RenderingRequest)this.delegate.element();
        }

        @Override
        public RenderingRequest peek() {
            return (RenderingRequest)this.delegate.peek();
        }

        @Override
        public void put(RenderingRequest e) throws InterruptedException {
            if (!StreamingRenderer.this.renderingStopRequested) {
                this.delegate.put((Object)e);
                if (StreamingRenderer.this.renderingStopRequested) {
                    this.clear();
                }
            }
        }

        @Override
        public boolean offer(RenderingRequest renderingRequest, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.offer((Object)renderingRequest, timeout, unit);
        }

        @Override
        public RenderingRequest take() throws InterruptedException {
            if (!StreamingRenderer.this.renderingStopRequested) {
                return (RenderingRequest)this.delegate.take();
            }
            return new EndRequest();
        }

        @Override
        public RenderingRequest poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (RenderingRequest)this.delegate.poll(timeout, unit);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends RenderingRequest> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super RenderingRequest> filter) {
            return this.delegate.removeIf(filter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Spliterator<RenderingRequest> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<RenderingRequest> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<RenderingRequest> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<RenderingRequest> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray((Object[])a);
        }

        @Override
        public int drainTo(Collection<? super RenderingRequest> list) {
            if (!StreamingRenderer.this.renderingStopRequested) {
                return this.delegate.drainTo(list);
            }
            list.clear();
            list.add(new EndRequest());
            return 1;
        }

        @Override
        public int drainTo(Collection<? super RenderingRequest> c, int maxElements) {
            return this.delegate.drainTo(c, maxElements);
        }
    }

    class PainterThread
    implements Runnable {
        BlockingQueue<RenderingRequest> requests;
        Thread thread;

        public PainterThread(BlockingQueue<RenderingRequest> requests) {
            this.requests = requests;
        }

        public void interrupt() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            boolean done = false;
            block3: while (!done) {
                try {
                    ArrayList<RenderingRequest> localRequests = new ArrayList<RenderingRequest>();
                    RenderingRequest request = this.requests.take();
                    this.requests.drainTo(localRequests);
                    localRequests.add(0, request);
                    for (RenderingRequest r : localRequests) {
                        if (r instanceof EndRequest || StreamingRenderer.this.renderingStopRequested) {
                            done = true;
                            continue block3;
                        }
                        r.execute();
                    }
                }
                catch (InterruptedException e) {
                    if (!StreamingRenderer.this.renderingStopRequested) continue;
                    done = true;
                }
                catch (Throwable t) {
                    StreamingRenderer.this.fireErrorEvent(t);
                }
            }
        }
    }

    protected class EndRequest
    extends RenderingRequest {
        protected EndRequest() {
        }

        @Override
        void execute() {
        }
    }

    protected class RenderDirectLayerRequest
    extends RenderingRequest {
        private final Graphics2D graphics;
        private final DirectLayer layer;

        public RenderDirectLayerRequest(Graphics2D graphics, DirectLayer layer) {
            this.graphics = graphics;
            this.layer = layer;
        }

        @Override
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering DirectLayer: " + this.layer);
            }
            if (this.graphics instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphics).init();
            }
            try {
                this.layer.draw(this.graphics, StreamingRenderer.this.mapContent, StreamingRenderer.this.mapContent.getViewport());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Layer rendered");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    protected class RenderCoverageReaderRequest
    extends RenderingRequest {
        private Graphics2D graphics;
        private GridCoverage2DReader reader;
        private RasterSymbolizer symbolizer;
        private CoordinateReferenceSystem destinationCRS;
        private AffineTransform worldToScreen;
        private GeneralParameterValue[] readParams;
        private Interpolation interpolation;

        public RenderCoverageReaderRequest(Graphics2D graphics, GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, AffineTransform worldToScreen, Interpolation interpolation) {
            this.graphics = graphics;
            this.reader = reader;
            this.readParams = readParams;
            this.symbolizer = symbolizer;
            this.destinationCRS = destinationCRS;
            this.worldToScreen = worldToScreen;
            this.interpolation = interpolation;
        }

        @Override
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering reader " + this.reader);
            }
            if (this.graphics instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphics).init();
            }
            try {
                GridCoverageRenderer gcr = new GridCoverageRenderer(this.destinationCRS, (org.locationtech.jts.geom.Envelope)StreamingRenderer.this.originalMapExtent, StreamingRenderer.this.screenSize, this.worldToScreen, StreamingRenderer.this.java2dHints);
                gcr.setAdvancedProjectionHandlingEnabled(StreamingRenderer.this.isAdvancedProjectionHandlingEnabled());
                gcr.setWrapEnabled(StreamingRenderer.this.isMapWrappingEnabled());
                gcr.paint(this.graphics, this.reader, this.readParams, this.symbolizer, this.interpolation, null);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Raster rendered");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    protected class RenderRasterRequest
    extends RenderingRequest {
        private Graphics2D graphics;
        private boolean disposeCoverage;
        private GridCoverage2D coverage;
        private RasterSymbolizer symbolizer;
        private CoordinateReferenceSystem destinationCRS;
        private AffineTransform worldToScreen;

        public RenderRasterRequest(Graphics2D graphics, GridCoverage2D coverage, boolean disposeCoverage, RasterSymbolizer symbolizer, CoordinateReferenceSystem destinationCRS, AffineTransform worldToScreen) {
            this.graphics = graphics;
            this.coverage = coverage;
            this.disposeCoverage = disposeCoverage;
            this.symbolizer = symbolizer;
            this.destinationCRS = destinationCRS;
            this.worldToScreen = worldToScreen;
        }

        @Override
        void execute() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering Raster " + this.coverage);
            }
            if (this.graphics instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphics).init();
            }
            try {
                GridCoverageRenderer gcr = new GridCoverageRenderer(this.destinationCRS, (org.locationtech.jts.geom.Envelope)StreamingRenderer.this.originalMapExtent, StreamingRenderer.this.screenSize, this.worldToScreen, StreamingRenderer.this.java2dHints);
                try {
                    gcr.paint(this.graphics, this.coverage, this.symbolizer);
                }
                finally {
                    if (this.coverage != null && this.disposeCoverage) {
                        this.coverage.dispose(true);
                        RenderedImage image = this.coverage.getRenderedImage();
                        if (image instanceof PlanarImage) {
                            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Raster rendered");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                StreamingRenderer.this.fireErrorEvent(e);
            }
        }
    }

    protected class MargeCompositingGroupRequest
    extends RenderingRequest {
        Graphics2D graphics;
        CompositingGroup compositingGroup;

        public MargeCompositingGroupRequest(Graphics2D graphics, CompositingGroup compositingGroup) {
            this.graphics = graphics;
            this.compositingGroup = compositingGroup;
        }

        @Override
        void execute() {
            BufferedImage image;
            if (this.graphics instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphics).init();
            }
            if ((image = ((DelayedBackbufferGraphic)this.compositingGroup.graphics).image) != null) {
                this.compositingGroup.graphics.dispose();
                Composite composite = this.compositingGroup.composite;
                if (composite == null) {
                    this.graphics.setComposite(AlphaComposite.SrcOver);
                } else {
                    this.graphics.setComposite(composite);
                }
                this.graphics.drawImage((Image)image, 0, 0, null);
            }
        }
    }

    protected class MergeLayersRequest
    extends RenderingRequest {
        Graphics2D graphics;
        List<LiteFeatureTypeStyle> lfts;

        public MergeLayersRequest(Graphics2D graphics, List<LiteFeatureTypeStyle> lfts) {
            this.graphics = graphics;
            this.lfts = lfts;
        }

        @Override
        void execute() {
            if (this.graphics instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphics).init();
            }
            for (LiteFeatureTypeStyle currentLayer : this.lfts) {
                Graphics2D ftsGraphics = currentLayer.graphics;
                if (!(ftsGraphics instanceof DelayedBackbufferGraphic) || ftsGraphics == this.graphics) continue;
                BufferedImage image = ((DelayedBackbufferGraphic)ftsGraphics).image;
                if (currentLayer.composite == null) {
                    this.graphics.setComposite(AlphaComposite.SrcOver);
                } else {
                    if (image == null) {
                        Rectangle size = ((DelayedBackbufferGraphic)ftsGraphics).screenSize;
                        image = new BufferedImage(size.width, size.height, 6);
                    }
                    this.graphics.setComposite(currentLayer.composite);
                }
                if (image == null) continue;
                this.graphics.drawImage((Image)image, 0, 0, null);
                ftsGraphics.dispose();
            }
        }
    }

    protected class FeatureRenderedRequest
    extends RenderingRequest {
        Object content;

        public FeatureRenderedRequest(Object content) {
            this.content = content;
        }

        @Override
        void execute() {
            StreamingRenderer.this.fireFeatureRenderedEvent(this.content);
        }
    }

    protected class PaintShapeRequest
    extends RenderingRequest {
        Graphics2D graphic;
        LiteShape2 shape;
        Style2D style;
        double scale;
        boolean labelObstacle;

        public PaintShapeRequest(Graphics2D graphic, LiteShape2 shape, Style2D style, double scale) {
            this.labelObstacle = false;
            this.graphic = graphic;
            this.shape = shape;
            this.style = style;
            this.scale = scale;
        }

        public void setLabelObstacle(boolean labelObstacle) {
            this.labelObstacle = labelObstacle;
        }

        @Override
        void execute() {
            if (this.graphic instanceof DelayedBackbufferGraphic) {
                ((DelayedBackbufferGraphic)this.graphic).init();
            }
            try {
                StreamingRenderer.this.painter.paint(this.graphic, this.shape, this.style, this.scale, this.labelObstacle);
            }
            catch (Throwable t) {
                StreamingRenderer.this.fireErrorEvent(t);
            }
        }
    }

    protected abstract class RenderingRequest {
        protected RenderingRequest() {
        }

        abstract void execute();
    }

    class RenderableFeature {
        Feature feature;
        Layer layer;
        boolean inMemoryGeneralization;
        ProjectionHandler projectionHandler;
        int metaBuffer;
        private IdentityHashMap symbolizerAssociationHT = new IdentityHashMap();
        private List geometries = new ArrayList();
        private List shapes = new ArrayList();
        private boolean clone;
        private IdentityHashMap decimators = new IdentityHashMap();
        private ScreenMap screenMap;
        private String layerId;

        public RenderableFeature(String layerId, boolean clone) {
            this.layerId = layerId;
            this.clone = clone;
        }

        public void setScreenMap(ScreenMap screenMap) {
            this.screenMap = screenMap;
        }

        public void setFeature(Feature feature) {
            this.feature = feature;
            this.geometries.clear();
            this.shapes.clear();
        }

        public LiteShape2 getShape(Symbolizer symbolizer, AffineTransform at) throws FactoryException {
            Geometry g = StreamingRenderer.this.findGeometry(this.feature, symbolizer);
            if (g == null || g.isEmpty()) {
                return null;
            }
            try {
                org.locationtech.jts.geom.Envelope env;
                if (this.screenMap != null && !(symbolizer instanceof PointSymbolizer) && !(g instanceof Point) && this.getGeometryIndex(g) == -1 && this.screenMap.canSimplify(env = g.getEnvelopeInternal())) {
                    if (this.screenMap.checkAndSet(env)) {
                        return null;
                    }
                    g = this.screenMap.getSimplifiedShape(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), g.getFactory(), g.getClass());
                }
                SymbolizerAssociation sa = (SymbolizerAssociation)this.symbolizerAssociationHT.get(symbolizer);
                MathTransform crsTransform = null;
                LinearTransform atTransform = null;
                MathTransform fullTransform = null;
                if (sa == null) {
                    sa = new SymbolizerAssociation();
                    sa.crs = StreamingRenderer.this.findGeometryCS(this.feature, symbolizer);
                    try {
                        crsTransform = StreamingRenderer.this.buildTransform(sa.crs, StreamingRenderer.this.destinationCrs);
                        atTransform = ProjectiveTransform.create((AffineTransform)StreamingRenderer.this.worldToScreenTransform);
                        fullTransform = StreamingRenderer.this.buildFullTransform(sa.crs, StreamingRenderer.this.destinationCrs, at);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    sa.xform = fullTransform;
                    sa.crsxform = crsTransform;
                    sa.axform = atTransform;
                    sa.rxform = this.projectionHandler != null ? this.projectionHandler.getRenderingTransform(sa.crsxform) : sa.crsxform;
                    this.symbolizerAssociationHT.put(symbolizer, sa);
                }
                if (symbolizer instanceof PointSymbolizer) {
                    if (!this.clone && g.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory) {
                        LiteShape2 first = this.getTransformedShape(g, sa);
                        if (first != null) {
                            if (this.projectionHandler != null) {
                                Geometry tx = JTS.transform((Geometry)first.getGeometry(), (MathTransform)sa.xform.inverse());
                                return this.getTransformedShape(RendererUtilities.getCentroid(tx), sa);
                            }
                            return this.getTransformedShape(RendererUtilities.getCentroid(g), null);
                        }
                        return null;
                    }
                    return this.getTransformedShape(RendererUtilities.getCentroid(g), sa);
                }
                return this.getTransformedShape(g, sa);
            }
            catch (TransformException te) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                StreamingRenderer.this.fireErrorEvent(te);
                return null;
            }
            catch (AssertionError ae) {
                LOGGER.log(Level.FINE, ((Throwable)((Object)ae)).getLocalizedMessage(), (Throwable)((Object)ae));
                StreamingRenderer.this.fireErrorEvent((Throwable)((Object)ae));
                return null;
            }
        }

        private int getGeometryIndex(Geometry g) {
            for (int i = 0; i < this.geometries.size(); ++i) {
                if (this.geometries.get(i) != g) continue;
                return i;
            }
            return -1;
        }

        private LiteShape2 getTransformedShape(Geometry originalGeom, SymbolizerAssociation sa) throws TransformException, FactoryException {
            LiteShape2 shape;
            int idx = this.getGeometryIndex(originalGeom);
            if (idx != -1) {
                return (LiteShape2)this.shapes.get(idx);
            }
            Geometry geom = originalGeom;
            if (this.clone || !(geom.getFactory().getCoordinateSequenceFactory() instanceof LiteCoordinateSequenceFactory)) {
                int dim = sa.crs != null ? sa.crs.getCoordinateSystem().getDimension() : 2;
                geom = LiteCoordinateSequence.cloneGeometry((Geometry)geom, (int)dim);
            }
            if (this.projectionHandler != null && sa != null) {
                if ((geom = this.projectionHandler.preProcess(geom)) == null) {
                    shape = null;
                } else {
                    Decimator d = this.getDecimator(sa.xform);
                    geom = d.decimateTransformGeneralize(geom, sa.rxform);
                    geom.geometryChanged();
                    MathTransform reverse = null;
                    if (sa.crsxform != null) {
                        if (sa.crsxform instanceof ConcatenatedTransform && ((ConcatenatedTransform)sa.crsxform).transform1.getTargetDimensions() >= 3 && ((ConcatenatedTransform)sa.crsxform).transform2.getTargetDimensions() == 2) {
                            reverse = null;
                        } else {
                            try {
                                reverse = sa.crsxform.inverse();
                            }
                            catch (Exception cannotReverse) {
                                reverse = null;
                            }
                        }
                    }
                    if ((geom = this.projectionHandler.postProcess(reverse, geom)) == null) {
                        shape = null;
                    } else {
                        d = new Decimator(-1.0, -1.0);
                        geom = d.decimateTransformGeneralize(geom, sa.axform);
                        geom.geometryChanged();
                        shape = new LiteShape2(geom, null, null, false, false);
                    }
                }
            } else {
                MathTransform xform = null;
                if (sa != null) {
                    xform = sa.xform;
                }
                shape = new LiteShape2(geom, xform, this.getDecimator(xform), false, false);
            }
            this.geometries.add(originalGeom);
            this.shapes.add(shape);
            return shape;
        }

        private Decimator getDecimator(MathTransform mathTransform) {
            if (StreamingRenderer.this.generalizationDistance == 0.0 || !this.inMemoryGeneralization) {
                return NULL_DECIMATOR;
            }
            Decimator decimator = (Decimator)this.decimators.get(mathTransform);
            if (decimator == null) {
                try {
                    decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse(), StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance) : new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                catch (org.opengis.referencing.operation.NoninvertibleTransformException e) {
                    decimator = new Decimator(null, StreamingRenderer.this.screenSize, StreamingRenderer.this.generalizationDistance);
                }
                this.decimators.put(mathTransform, decimator);
            }
            return decimator;
        }
    }
}

