/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class MouseDragBox
extends MouseInputAdapter {
    private final JComponent parentComponent;
    private Point startPos;
    private Rectangle rect;
    private boolean dragged;
    private boolean enabled;
    private Graphics2D graphics;

    public MouseDragBox(JComponent component) {
        this.parentComponent = component;
        this.rect = new Rectangle();
        this.dragged = false;
        this.enabled = false;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.startPos = new Point(ev.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.enabled) {
            this.ensureGraphics();
            if (this.dragged) {
                this.graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
            this.rect.setFrameFromDiagonal(this.startPos, ev.getPoint());
            this.graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            this.dragged = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.dragged) {
            this.ensureGraphics();
            this.graphics.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            this.dragged = false;
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    private void ensureGraphics() {
        if (this.graphics == null) {
            this.graphics = (Graphics2D)this.parentComponent.getGraphics().create();
            this.graphics.setColor(Color.WHITE);
            this.graphics.setXORMode(Color.RED);
        }
    }
}

