/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

public class FeatureCollectionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7119885084300393935L;
    private SimpleFeatureType schema;
    List<Object[]> cache = new ArrayList<Object[]>();
    public IOException exception;
    TableWorker load;

    public FeatureCollectionTableModel(SimpleFeatureCollection features) {
        this.load = new TableWorker(features);
        this.load.execute();
        this.schema = (SimpleFeatureType)features.getSchema();
    }

    public void dispose() {
        this.load.cancel(false);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "FeatureIdentifer";
        }
        return this.schema.getDescriptor(column - 1).getLocalName();
    }

    @Override
    public int getColumnCount() {
        if (this.exception != null) {
            return 1;
        }
        return this.schema.getAttributeCount() + 1;
    }

    @Override
    public int getRowCount() {
        if (this.exception != null) {
            return 1;
        }
        return this.cache.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.cache.size()) {
            Object[] row = this.cache.get(rowIndex);
            return row[columnIndex];
        }
        return null;
    }

    class TableWorker
    extends SwingWorker<List<Object[]>, Object[]> {
        SimpleFeatureCollection features;

        TableWorker(SimpleFeatureCollection features) {
            this.features = features;
        }

        @Override
        public List<Object[]> doInBackground() {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            final NullProgressListener listener = new NullProgressListener();
            try {
                this.features.accepts(new FeatureVisitor(){

                    public void visit(Feature feature) {
                        SimpleFeature simple = (SimpleFeature)feature;
                        Object[] values = simple.getAttributes().toArray();
                        ArrayList<Object> row = new ArrayList<Object>(Arrays.asList(values));
                        row.add(0, simple.getID());
                        TableWorker.this.publish((Object[])new Object[][]{row.toArray()});
                        if (TableWorker.this.isCancelled()) {
                            listener.setCanceled(true);
                        }
                    }
                }, (ProgressListener)listener);
            }
            catch (IOException e) {
                FeatureCollectionTableModel.this.exception = e;
            }
            return list;
        }

        @Override
        protected void process(List<Object[]> chunks) {
            int from = FeatureCollectionTableModel.this.cache.size();
            FeatureCollectionTableModel.this.cache.addAll(chunks);
            int to = FeatureCollectionTableModel.this.cache.size();
            FeatureCollectionTableModel.this.fireTableRowsInserted(from, to);
        }
    }
}

