/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.resManager.catalog.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.SelectTreeModel;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.resManager.catalog.entity.Rescatalog;
import org.jeecg.modules.resManager.catalog.mapper.RescatalogMapper;
import org.jeecg.modules.resManager.catalog.service.IRescatalogService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RescatalogServiceImpl
extends ServiceImpl<RescatalogMapper, Rescatalog>
implements IRescatalogService {
    @Override
    public void addRescatalog(Rescatalog rescatalog) {
        rescatalog.setHasChild("0");
        if (oConvertUtils.isEmpty((Object)rescatalog.getPid())) {
            rescatalog.setPid("0");
        } else {
            Rescatalog parent = (Rescatalog)((RescatalogMapper)this.baseMapper).selectById((Serializable)((Object)rescatalog.getPid()));
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                ((RescatalogMapper)this.baseMapper).updateById(parent);
            }
        }
        ((RescatalogMapper)this.baseMapper).insert(rescatalog);
    }

    @Override
    public void updateRescatalog(Rescatalog rescatalog) {
        String new_pid;
        Rescatalog entity = (Rescatalog)this.getById((Serializable)((Object)rescatalog.getId()));
        if (entity == null) {
            throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        String old_pid = entity.getPid();
        if (!old_pid.equals(new_pid = rescatalog.getPid())) {
            this.updateOldParentNode(old_pid);
            if (oConvertUtils.isEmpty((Object)new_pid)) {
                rescatalog.setPid("0");
            }
            if (!"0".equals(rescatalog.getPid())) {
                ((RescatalogMapper)this.baseMapper).updateTreeNodeStatus(rescatalog.getPid(), "1");
            }
        }
        ((RescatalogMapper)this.baseMapper).updateById(rescatalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRescatalog(String id) throws JeecgBootException {
        if ((id = this.queryTreeChildIds(id)).indexOf(",") > 0) {
            String[] pidArr;
            String[] idArr;
            StringBuffer sb = new StringBuffer();
            for (String idVal : idArr = id.split(",")) {
                boolean flag;
                if (idVal == null) continue;
                Rescatalog rescatalog = (Rescatalog)this.getById((Serializable)((Object)idVal));
                String pidVal = rescatalog.getPid();
                List dataList = ((RescatalogMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)pidVal)).notIn((Object)"id", Arrays.asList(idArr)));
                boolean bl = flag = (dataList == null || dataList.size() == 0) && !Arrays.asList(idArr).contains(pidVal) && !sb.toString().contains(pidVal);
                if (!flag) continue;
                sb.append(pidVal).append(",");
            }
            ((RescatalogMapper)this.baseMapper).deleteBatchIds(Arrays.asList(idArr));
            for (String pid : pidArr = sb.toString().split(",")) {
                this.updateOldParentNode(pid);
            }
        } else {
            Rescatalog rescatalog = (Rescatalog)this.getById((Serializable)((Object)id));
            if (rescatalog == null) {
                throw new JeecgBootException("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            }
            this.updateOldParentNode(rescatalog.getPid());
            ((RescatalogMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public List<Rescatalog> queryTreeListNoPage(QueryWrapper<Rescatalog> queryWrapper) {
        List dataList = ((RescatalogMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        ArrayList<Rescatalog> mapList = new ArrayList<Rescatalog>();
        for (Rescatalog data : dataList) {
            String pidVal = data.getPid();
            if (pidVal != null && !"0".equals(pidVal)) {
                Rescatalog rootVal = this.getTreeRoot(pidVal);
                if (rootVal == null || mapList.contains(rootVal)) continue;
                mapList.add(rootVal);
                continue;
            }
            if (mapList.contains(data)) continue;
            mapList.add(data);
        }
        return mapList;
    }

    @Override
    public List<SelectTreeModel> queryListByCode(String parentCode) {
        String pid = "0";
        if (oConvertUtils.isNotEmpty((Object)parentCode)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(Rescatalog::getPid, (Object)parentCode);
            List list = ((RescatalogMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (list == null || list.size() == 0) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + parentCode + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            if (list.size() > 1) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + parentCode + "\u3011\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u6838\u5b9e!");
            }
            pid = ((Rescatalog)list.get(0)).getId();
        }
        return ((RescatalogMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<SelectTreeModel> queryListByPid(String pid) {
        if (oConvertUtils.isEmpty((Object)pid)) {
            pid = "0";
        }
        return ((RescatalogMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<Rescatalog> queryByUser(String username) {
        return ((RescatalogMapper)this.baseMapper).queryByUser(username);
    }

    @Override
    public int queryCountByUsername(String username, String resId) {
        return ((RescatalogMapper)this.baseMapper).queryCountByUsername(username, resId);
    }

    @Override
    public void subLayerIdAdditive(int addid) {
        ((RescatalogMapper)this.baseMapper).subLayerIdAdditive(addid);
    }

    @Override
    public void subLayerIdDecrement(int delid) {
        ((RescatalogMapper)this.baseMapper).subLayerIdDecrement(delid);
    }

    private void updateOldParentNode(String pid) {
        Long count;
        if (!("0".equals(pid) || (count = ((RescatalogMapper)this.baseMapper).selectCount((Wrapper)new QueryWrapper().eq((Object)"pid", (Object)pid))) != null && count > 1L)) {
            ((RescatalogMapper)this.baseMapper).updateTreeNodeStatus(pid, "0");
        }
    }

    private Rescatalog getTreeRoot(String pidVal) {
        Rescatalog data = (Rescatalog)((RescatalogMapper)this.baseMapper).selectById((Serializable)((Object)pidVal));
        if (data != null && !"0".equals(data.getPid())) {
            return this.getTreeRoot(data.getPid());
        }
        return data;
    }

    private String queryTreeChildIds(String ids) {
        String[] idArr = ids.split(",");
        StringBuffer sb = new StringBuffer();
        for (String pidVal : idArr) {
            if (pidVal == null || sb.toString().contains(pidVal)) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(pidVal);
            this.getTreeChildIds(pidVal, sb);
        }
        return sb.toString();
    }

    private StringBuffer getTreeChildIds(String pidVal, StringBuffer sb) {
        List dataList = ((RescatalogMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().eq((Object)"pid", (Object)pidVal));
        if (dataList != null && dataList.size() > 0) {
            for (Rescatalog tree : dataList) {
                if (!sb.toString().contains(tree.getId())) {
                    sb.append(",").append(tree.getId());
                }
                this.getTreeChildIds(tree.getId(), sb);
            }
        }
        return sb;
    }
}

