/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.BucketArgs;
import io.minio.messages.ReplicationConfiguration;

public class SetBucketReplicationArgs
extends BucketArgs {
    private ReplicationConfiguration config;
    private String objectLockToken;

    public ReplicationConfiguration config() {
        return this.config;
    }

    public String objectLockToken() {
        return this.objectLockToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetBucketReplicationArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetBucketReplicationArgs that = (SetBucketReplicationArgs)o;
        return Objects.equal((Object)this.config, (Object)that.config) && Objects.equal((Object)this.objectLockToken, (Object)that.objectLockToken);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.config, this.objectLockToken});
    }

    public static final class Builder
    extends BucketArgs.Builder<Builder, SetBucketReplicationArgs> {
        private void validateConfig(ReplicationConfiguration config) {
            this.validateNotNull(config, "replication configuration");
        }

        private void validateObjectLockToken(String token) {
            this.validateNullOrNotEmptyString(token, "object lock token");
        }

        @Override
        protected void validate(SetBucketReplicationArgs args) {
            super.validate(args);
            this.validateConfig(args.config);
            this.validateObjectLockToken(args.objectLockToken);
        }

        public Builder config(ReplicationConfiguration config) {
            this.validateConfig(config);
            this.operations.add(args -> ((SetBucketReplicationArgs)args).config = config);
            return this;
        }

        public Builder objectLockToken(String token) {
            this.validateObjectLockToken(token);
            this.operations.add(args -> ((SetBucketReplicationArgs)args).objectLockToken = token);
            return this;
        }
    }
}

