/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Defaults;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.AbstractDocumentationPluginsBootstrapper;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.plugins.SpringIntegrationPluginNotPresentInClassPathCondition;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;

@Component
@Conditional(value={SpringIntegrationPluginNotPresentInClassPathCondition.class})
public class DocumentationPluginsBootstrapper
extends AbstractDocumentationPluginsBootstrapper
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentationPluginsBootstrapper.class);
    private static final String SPRINGFOX_DOCUMENTATION_AUTO_STARTUP = "springfox.documentation.auto-startup";
    private final Environment environment;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    @Autowired
    public DocumentationPluginsBootstrapper(DocumentationPluginsManager documentationPluginsManager, List<RequestHandlerProvider> handlerProviders, DocumentationCache scanned, ApiDocumentationScanner resourceListing, TypeResolver typeResolver, Defaults defaults, PathProvider pathProvider, Environment environment) {
        super(documentationPluginsManager, handlerProviders, scanned, resourceListing, defaults, typeResolver, pathProvider);
        this.environment = environment;
    }

    public boolean isAutoStartup() {
        String autoStartupConfig = this.environment.getProperty(SPRINGFOX_DOCUMENTATION_AUTO_STARTUP, "true");
        return Boolean.parseBoolean(autoStartupConfig);
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public void start() {
        if (this.initialized.compareAndSet(false, true)) {
            LOGGER.debug("Documentation plugins bootstrapped");
            super.bootstrapDocumentationPlugins();
        }
    }

    public void stop() {
        this.initialized.getAndSet(false);
        this.getScanned().clear();
    }

    public boolean isRunning() {
        return this.initialized.get();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Autowired(required=false)
    public void setCombiner(RequestHandlerCombiner combiner) {
        super.setCombiner(combiner);
    }

    @Override
    @Autowired(required=false)
    public void setTypeConventions(List<AlternateTypeRuleConvention> typeConventions) {
        super.setTypeConventions(typeConventions);
    }
}

