/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.Parameter;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.wizard.JWizard;
import org.geotools.swing.wizard.ParamField;
import org.geotools.util.URLs;

public class JURLField
extends ParamField {
    private JTextField field;
    private JButton browse;

    public JURLField(Parameter<?> parameter) {
        super(parameter);
    }

    @Override
    public JComponent doLayout() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0"));
        this.field = new JTextField(32);
        panel.add((Component)this.field, "width 200::700, growx");
        this.browse = new JButton("Browse");
        panel.add((Component)this.browse, "wrap");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JURLField.this.browse();
            }
        });
        return panel;
    }

    protected void browse() {
        Object format = this.parameter.metadata.get("ext");
        JFileChooser dialog = format instanceof FileDataStoreFactorySpi ? new JFileDataStoreChooser((FileDataStoreFactorySpi)format) : (format instanceof String ? new JFileDataStoreChooser((String)format) : (format instanceof String[] ? new JFileDataStoreChooser((String[])format) : new JFileChooser()));
        dialog.setSelectedFile(this.getFile());
        int returnVal = dialog.showOpenDialog(this.browse);
        if (returnVal == 0) {
            File file = dialog.getSelectedFile();
            this.setValue(file);
        }
    }

    @Override
    public URL getValue() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return null;
        }
        try {
            File file = new File(txt);
            return file.toURI().toURL();
        }
        catch (Exception exception) {
            try {
                return new URL(txt);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    @Override
    public void addListener(JWizard.Controller controller) {
        this.field.addActionListener(controller);
        this.field.getDocument().addDocumentListener(controller);
    }

    @Override
    public void removeListener(JWizard.Controller controller) {
        this.field.removeActionListener(controller);
        this.field.getDocument().removeDocumentListener(controller);
    }

    public File getFile() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return null;
        }
        try {
            File file = new File(txt);
            return file;
        }
        catch (Exception file) {
            try {
                URL url = new URL(txt);
                return URLs.urlToFile((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof File) {
            File file = (File)value;
            this.field.setText(file.toString());
        } else if (value instanceof URL) {
            URL url = (URL)value;
            this.field.setText(url.toExternalForm());
        } else if (value instanceof String) {
            this.field.setText((String)value);
        }
    }

    @Override
    public boolean validate() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return !this.parameter.required;
        }
        File file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        URL url = this.getValue();
        return url != null;
    }
}

