/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.crazycake.shiro.exception.SerializationException;
import org.crazycake.shiro.serializer.RedisSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSerializer
implements RedisSerializer<Object> {
    private static Logger logger = LoggerFactory.getLogger(ObjectSerializer.class);
    public static final int BYTE_ARRAY_OUTPUT_STREAM_SIZE = 128;

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        byte[] result = new byte[]{};
        if (object == null) {
            return result;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
        if (!(object instanceof Serializable)) {
            throw new SerializationException("requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            result = byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException("serialize error, object=" + object, e);
        }
        return result;
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        Object result = null;
        if (bytes == null || bytes.length == 0) {
            return result;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
            result = objectInputStream.readObject();
        }
        catch (IOException e) {
            throw new SerializationException("deserialize error", e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("deserialize error", e);
        }
        return result;
    }
}

